<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'MWT_Fields_Taxonomy' ) ) :

	class MWT_Fields_Taxonomy extends MWT_Fields {

		public $mwt_view = 'add';
		public $mwt_taxonomy;
		public $mwt_options;
		public $mwt_options_subdirectory = 'taxonomies';

		/**
		 * __construct
		 *
		 * @type    function
		 * @date    7/01/2019
		 *
		 * @param n/a
		 *
		 * @return    void
		 * @since    0.0.1
		 *
		 */

		public function __construct() {

			add_action( 'init', array( $this, 'init' ), 10 );

		}

		/**
		 * init
		 *
		 * @type    function
		 * @date    3/25/2020
		 *
		 * @param n/a
		 *
		 * @return    void
		 * @since    0.0.1
		 *
		 */

		public function init() {

			//check user access
			if ( ! current_user_can( 'manage_categories' ) ) {
				return;
			}

			if ( ! $this->validate_page() ) {
				return;
			}

			//get taxonomy to edit
			$mwt_taxonomy = '';
			if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
				if ( isset( $_POST['action'] ) ) {
					if ( 'add-tag' === sanitize_title( wp_unslash( $_POST['action'] ) ) ) {
						if ( isset( $_POST['taxonomy'] ) ) {
							$mwt_taxonomy = sanitize_title( wp_unslash( $_POST['taxonomy'] ) );
						}
					}
				}
			} else {
				//can be empty on edit screen after submit form
				if ( isset( $_REQUEST['taxonomy'] ) ) {
					$mwt_get_taxonomy = sanitize_title( wp_unslash( $_REQUEST['taxonomy'] ) );
					$mwt_taxonomy     = ! empty( $mwt_get_taxonomy ) ? esc_html( $mwt_get_taxonomy ) : '';
				}
			}
			if ( empty( $mwt_taxonomy ) ) {
				return;
			}

			$this->mwt_taxonomy         = $mwt_taxonomy;
			$this->mwt_options_filename = $mwt_taxonomy;

			//where options file are located
			$this->mwt_options_directory = apply_filters( 'energy_options_directory', 'options' );
			//options array
			$this->mwt_options = $this->get_fields( $mwt_taxonomy );

			// actions
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );

			// save
			add_action( 'create_term', array( $this, 'save_term' ), 10, 3 );
			add_action( 'edit_term', array( $this, 'save_term' ), 10, 3 );

		}

		/**
		 * validate_page
		 *
		 * This function will check if the current page is for a post/page edit form
		 *
		 * @date    7/01/2019
		 *
		 * @param n/a
		 *
		 * @return    boolean
		 * @since    0.0.1
		 *
		 */

		protected function validate_page() {

			// global
			global $pagenow;

			// validate page
			if ( 'edit-tags.php' === $pagenow || 'term.php' === $pagenow ) {
				return true;
			}

			//ajax when creating category
			if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
				if ( ! empty( $_POST['action'] ) ) {
					if ( 'add-tag' === $_POST['action'] ) {
						if ( check_ajax_referer( 'add-tag', '_wpnonce_add-tag' ) ) {
							return true;
						}
					}
				}
			}

			// return
			return false;
		}


		/**
		 * admin_enqueue_scripts
		 *
		 * Runs after post query but before any admin script / head actions.
		 *
		 * @type    action (admin_enqueue_scripts)
		 * @date    7/01/2019
		 *
		 * @param N/A
		 *
		 * @return    N/A
		 * @since    0.0.1
		 *
		 */

		public function admin_enqueue_scripts() {

			// validate page
			if ( ! $this->validate_page() ) {
				return;
			}

			$mwt_taxonomy = $this->mwt_taxonomy;

			// load energy scripts
			// energy_enqueue_scripts();

			// actions
			add_action( 'admin_footer', array( $this, 'admin_footer' ), 10, 1 );
			add_action( "{$mwt_taxonomy}_add_form_fields", array( $this, 'add_term' ) );
			add_action( "{$mwt_taxonomy}_edit_form_fields", array( $this, 'edit_term' ), 10, 1 );

		}

		/**
		 * render fields from options array
		 * @date    7/01/2019
		 *
		 * @param options array
		 * @param term_id string
		 * @param tag string
		 *
		 * @since    0.0.1
		 *
		 */
		protected function render_fields( $mwt_options, $mwt_term_id, $mwt_tag ) {

			//create our custom nonce field
			wp_nonce_field( - 1, 'energy-fields' );

			foreach ( $mwt_options as $mwt_id => $mwt_option ) :

				$mwt_term_meta = get_term_meta( $mwt_term_id, $mwt_id, true );

				$mwt_value = $this->get_value( $mwt_term_meta, $mwt_option );

				$this->render_field( $mwt_id, $mwt_option, $mwt_value, $mwt_tag );

			endforeach;
		}

		/**
		 *  add_term form
		 *
		 * @date    7/01/2019
		 * @since    0.0.1
		 *
		 *
		 */

		public function add_term() {

			// vars
			$mwt_term_id = 0;

			// update vars
			$this->mwt_view = 'add';

			// get field groups
			$mwt_options = $this->mwt_options;

			// render
			if ( ! empty( $mwt_options ) ) {

				// wrap
				echo '<div id="energy-term-fields" class="energy-fields clear">';

				$this->render_fields( $mwt_options, $mwt_term_id, 'div' );

				// end wrap
				echo '</div><!-- #energy-term-fields -->';

			}

		}


		/**
		 * edit_term form
		 *
		 * adds fields to edit term screen
		 *
		 * @type    function
		 * @date    7/01/2019
		 *
		 * @param    $mwt_term (int)
		 *
		 * @since    0.0.1
		 *
		 */

		public function edit_term( $mwt_term ) {

			// vars
			$mwt_term_id = $mwt_term->term_id;

			// update vars
			$this->view = 'edit';

			// get field groups
			$mwt_options = $this->mwt_options;

			// render
			if ( ! empty( $mwt_options ) ) :

				$this->render_fields( $mwt_options, $mwt_term_id, 'tr' );

			endif; //$mwt_options

		}


		/**
		 * save_term action
		 *
		 * saving term meta data on new term and on edit term actions
		 *
		 * @type    function
		 * @date    7/01/2019
		 *
		 * @param    $mwt_term_id (int)
		 * @param    $mwt_tt_id (int)
		 * @param    $mwt_taxonomy (obj)
		 *
		 * @return void
		 * @since    0.0.1
		 *
		 */

		public function save_term( $mwt_term_id, $mwt_tt_id, $mwt_taxonomy ) {

			if ( empty( $_POST['energy-fields'] ) ) {
				return $mwt_term_id;
			}
			if ( ! wp_verify_nonce( sanitize_title( wp_unslash( $_POST['energy-fields'] ) ) ) ) {
				return $mwt_term_id;
			}

			$mwt_options = $this->mwt_options;
			//if editing term
			if ( empty( $mwt_options ) ) {
				$mwt_options = $this->get_fields( $mwt_taxonomy );
			}

			if ( ! empty( $mwt_options ) ) :

				$mwt_keys = array_keys( $mwt_options );

				foreach ( $mwt_keys as $mwt_key ) :
					if ( isset( $_POST[ $mwt_key ] ) ) {

						$mwt_value = sanitize_text_field( sanitize_text_field( wp_unslash( $_POST[ $mwt_key ] ) ) );
						//for checkbox - set true to 1
						if ( 'checkbox' === $mwt_options[ $mwt_key ]['type'] ) {
							$mwt_value = '1';
						}
						update_term_meta( $mwt_term_id, $mwt_key, $mwt_value );
					}
					//checking empty value for checkbox and putting '0' string if checkbox was not checked
					if ( 'checkbox' === $mwt_options[ $mwt_key ]['type'] && ! isset( $_POST[ $mwt_key ] ) ) {
						update_term_meta( $mwt_term_id, $mwt_key, '0' );
					}
				endforeach;

			endif;

		}


		/**
		 * admin_footer
		 *
		 * description
		 *
		 * @type    function
		 * @date    7/01/2019
		 *
		 * @param n/a
		 *
		 * @return    void
		 * @since    0.0.1
		 *
		 */

		public function admin_footer() {

		}

	}

endif; //class_exists

new MWT_Fields_Taxonomy();
