<?php

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!class_exists('MWT_Fields_User')) :

	class MWT_Fields_User
	{


		/**
		 * __construct
		 *
		 * Adds needed actions.
		 *
		 * @date    7/01/2019
		 *
		 * @param void
		 *
		 * @return    void
		 * @since    0.0.1
		 *
		 */
		public function __construct()
		{
			add_filter('user_contactmethods', array($this, 'filter_user_contact_methods'));
			add_action('admin_print_scripts-profile.php', array($this, 'energy_action_add_custom_profile_image_script'));
		}

		public function filter_user_contact_methods($mwt_profile_fields)
		{

			// Add new fields
			$mwt_profile_fields['custom_profile_image'] = esc_html__('Custom Profile Image', 'energy');

			//adding user social contacts
			$mwt_profile_fields['facebook'] = esc_html__('Facebook URL', 'energy');
			$mwt_profile_fields['twitter'] = esc_html__('Twitter URL', 'energy');
			$mwt_profile_fields['instagram'] = esc_html__('Instagram URL', 'energy');
			$mwt_profile_fields['linkedin'] = esc_html__('Linkedin URL', 'energy');
			$mwt_profile_fields['youtube'] = esc_html__('Youtube URL', 'energy');

			return $mwt_profile_fields;
		}




		//admin script for custom profile image
		public function energy_action_add_custom_profile_image_script()
		{
			$mwt_prefix = MWT_FIELDS_PLUGIN_URL . '/assets/';
			if (defined('ENERGY_DEV_MODE')) {
				if (ENERGY_DEV_MODE) {
					$mwt_prefix = ENERGY_THEME_URI . '/dev/extensions/mwt-fields/assets/';
				}
			}
			wp_enqueue_media();
			wp_enqueue_script(
				'energy-user-profile-image',
				$mwt_prefix . 'js/user-profile-image.js',
				array('jquery'),
				'0.0.1',
				true
			);
		} //energy_action_add_custom_profile_image_script()

	}

endif; //class_exists

new MWT_Fields_User();
