<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'MWT_Fields' ) ) :

	class MWT_Fields {

		public $mwt_options_directory;
		public $mwt_options_subdirectory;
		public $mwt_options_filename;

		/**
		 * get options from theme options folder
		 * child theme has priority
		 *
		 * @param $mwt_options_filename string
		 *
		 * @date    7/01/2019
		 * @return array
		 * @since    0.0.1
		 */
		protected function get_fields( $mwt_options_filename = '' ) {

			//TODO use locate_template();

			$mwt_options = array();
			//if edit post_type form submitted
			if ( empty( $mwt_options_filename ) ) {
				$mwt_options_filename = $this->mwt_options_filename;
			}

			//child theme is active
			//it has higher priority
			if ( is_child_theme() ) :
				$mwt_file = get_stylesheet_directory() . '/' . $this->mwt_options_directory . '/' . $this->mwt_options_subdirectory . '/' . $mwt_options_filename . '.php';

				if ( is_file( $mwt_file ) ) :
					//get options from child theme options
					$mwt_options = include_once $mwt_file;

					//searching for options in parent theme
				else :
					$mwt_file = get_template_directory() . '/' . $this->mwt_options_directory . '/' . $this->mwt_options_subdirectory . '/' . $mwt_options_filename . '.php';
					if ( is_file( $mwt_file ) ) {
						//get options from parent theme options
						$mwt_options = include_once $mwt_file;
					}
				endif;

				//parent theme is active
				else :
					$mwt_file = get_stylesheet_directory() . '/' . $this->mwt_options_directory . '/' . $this->mwt_options_subdirectory . '/' . $mwt_options_filename . '.php';
					if ( is_file( $mwt_file ) ) {
						//get options from parent theme options
						$mwt_options = include_once $mwt_file;
					}
			endif;

				if ( empty( $mwt_options ) ) {
					return array();
				}

				if ( is_array( $mwt_options ) ) {
					return $mwt_options;
				}

				return array();

		}

		/**
		 * @param $mwt_meta_value
		 * @param $mwt_option
		 *
		 * @return string
		 */
		protected function get_value( $mwt_meta_value, $mwt_option ) {

			//process checkbox
			if ( 'checkbox' === $mwt_option['type'] && '0' === $mwt_meta_value ) {
				return '0';
			}

			//if default not set - set to empty string
			if ( empty( $mwt_option['default'] ) ) {
				$mwt_option['default'] = '';
			}

			//trying to get saved value if exists
			$mwt_value = ( ! empty( $mwt_meta_value ) ) ? $mwt_meta_value : '';
			//if no value in meta - trying default value
			if ( empty( $mwt_value ) ) {
				$mwt_value = ! empty( $mwt_option['default'] ) ? $mwt_option['default'] : '';
			}

			//process checkbox
			if ( 'checkbox' === $mwt_option['type'] ) {
				$mwt_value = ( empty( $mwt_value ) ) ? '0' : '1';
			}

			return $mwt_value;

		}


		/**
		 * render fields from options array
		 * @date    7/01/2019
		 *
		 * @param energy_id string
		 * @param energy_option array
		 * @param energy_value string
		 * @param energy_tag string
		 *
		 * @since    0.0.1
		 *
		 */
		protected function render_field( $mwt_id, $mwt_option, $mwt_value, $mwt_tag ) {

			//TODO each option type to separate file
			switch ( $mwt_option['type'] ) :

				//////////
				//select//
				//////////
				case 'select':
					if ( empty( $mwt_option['choices'] ) ) {
						echo esc_html__( 'No choices provided', 'energy' );
						break;
					}
					?>
					<<?php echo esc_attr( $mwt_tag ); ?> class="form-field <?php echo esc_attr( $mwt_id ); ?>-wrap">
					<?php
					if ( 'tr' === $mwt_tag ) {
						echo '<th>';
					}
					?>
					<label
						for="<?php echo esc_attr( $mwt_id ); ?>"><?php echo esc_html( $mwt_option['label'] ); ?></label>
					<?php
					if ( 'tr' === $mwt_tag ) {
						echo '</th>';
						echo '<td>';
					}
					?>
					<select
						name="<?php echo esc_attr( $mwt_id ); ?>"
						id="<?php echo esc_attr( $mwt_id ); ?>"
						class="widefat"
						data-default-value="<?php echo esc_attr( $mwt_option['default'] ); ?>"
					>
						<?php
						foreach ( $mwt_option['choices'] as $mwt_choice_value => $mwt_choice_description ) :
							?>
							<option
								value="<?php echo esc_attr( $mwt_choice_value ); ?>"<?php selected( $mwt_choice_value, $mwt_value ); ?>><?php echo esc_html( $mwt_choice_description ); ?></option>
						<?php endforeach; ?>
					</select>
					<?php if ( ! empty( $mwt_option['description'] ) ) : ?>
					<p class="description"><?php echo esc_html( $mwt_option['description'] ); ?></p>
				<?php endif; ?>
					<?php
					if ( 'tr' === $mwt_tag ) {
						echo '</td>';
					}
					?>
					</<?php echo esc_attr( $mwt_tag ); ?>>
					<?php
					break;

				/////////
				//radio//
				/////////
				case 'radio':
					if ( empty( $mwt_option['choices'] ) ) {
						echo esc_html__( 'No choices provided', 'energy' );
						break;
					}
					?>
					<<?php echo esc_attr( $mwt_tag ); ?> class="form-field <?php echo esc_attr( $mwt_id ); ?>-wrap">
					<?php
					if ( 'tr' === $mwt_tag ) {
						echo '<th>';
					}
					?>
					<label><?php echo esc_html( $mwt_option['label'] ); ?></label>
					<?php
					if ( 'tr' === $mwt_tag ) {
						echo '</th>';
						echo '<td>';
					}
					foreach ( $mwt_option['choices'] as $mwt_choice_value => $mwt_choice_description ) :
						?>
						<div>
							<label>
								<input
									type="radio"
									id="energy-radio-<?php echo esc_attr( $mwt_choice_value ); ?>"
									name="<?php echo esc_attr( $mwt_id ); ?>"
									value="<?php echo esc_attr( $mwt_choice_value ); ?>"
									<?php checked( $mwt_choice_value, $mwt_value ); ?>
									data-default-value="<?php echo esc_attr( $mwt_option['default'] ); ?>"
								>
								<?php echo esc_html( $mwt_choice_description ); ?>
							</label>
						</div>
					<?php endforeach; ?>
					<?php if ( ! empty( $mwt_option['description'] ) ) : ?>
					<p class="description"><?php echo esc_html( $mwt_option['description'] ); ?></p>
				<?php endif; ?>
					<?php
					if ( 'tr' === $mwt_tag ) {
						echo '</td>';
					}
					?>
					</<?php echo esc_attr( $mwt_tag ); ?>>
					<?php
					break;

				////////////
				//checkbox//
				////////////
				case 'checkbox':
					$mwt_current_default_value = ( ! empty( $mwt_option['default'] ) ) ? '1' : '0';
					?>
					<<?php echo esc_attr( $mwt_tag ); ?> class="form-field <?php echo esc_attr( $mwt_id ); ?>-wrap">
					<?php
					if ( 'tr' === $mwt_tag ) :
						?>
						<th>
							<label
								for="<?php echo esc_attr( $mwt_id ); ?>"><?php echo esc_html( $mwt_option['label'] ); ?></label>
						</th>
						<td>
						<?php
					endif; //tr
					?>
					<label>
						<input
							type="checkbox"
							id="<?php echo esc_attr( $mwt_id ); ?>"
							name="<?php echo esc_attr( $mwt_id ); ?>"
							<?php echo ( '1' === ( $mwt_value ) ) ? 'checked="checked"' : ''; ?>
							data-default-value="<?php echo esc_attr( $mwt_current_default_value ); ?>"
						>
						<?php echo esc_html( $mwt_option['label'] ); ?>
					</label>
					<?php if ( ! empty( $mwt_option['description'] ) ) : ?>
					<p class="description"><?php echo esc_html( $mwt_option['description'] ); ?></p>
				<?php endif; ?>
					<?php
					if ( 'tr' === $mwt_tag ) {
						echo '<td>';
					}
					?>
					</<?php echo esc_attr( $mwt_tag ); ?>>
					<?php

					break;

				////////
				//text//
				////////
				default:
					?>
					<<?php echo esc_attr( $mwt_tag ); ?> class="form-field <?php echo esc_attr( $mwt_id ); ?>-wrap">
					<?php
					if ( 'tr' === $mwt_tag ) {
						echo '<th>';
					}
					?>
					<label
						for="<?php echo esc_attr( $mwt_id ); ?>"><?php echo esc_html( $mwt_option['label'] ); ?></label>
					<?php
					if ( 'tr' === $mwt_tag ) {
						echo '</th>';
						echo '<td>';
					}
					?>
					<input
						type="text"
						id="<?php echo esc_attr( $mwt_id ); ?>"
						name="<?php echo esc_attr( $mwt_id ); ?>"
						value="<?php echo esc_attr( $mwt_value ); ?>"
						data-default-value="<?php echo esc_attr( $mwt_option['default'] ); ?>"
					>
					<?php if ( ! empty( $mwt_option['description'] ) ) : ?>
					<p class="description"><?php echo esc_html( $mwt_option['description'] ); ?></p>
				<?php endif; ?>
					<?php
					if ( 'tr' === $mwt_tag ) {
						echo '<td>';
					}
					?>
						</<?php echo esc_attr( $mwt_tag ); ?>>
					<?php
			endswitch;
		}
	}

endif; //class_exists
