<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Elementor MWT Tabs Accordion Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

class Elementor_MWT_Tabs_Accordion extends \Elementor\Widget_Base

{
    /**
     * Retrieve Widget Dependent JS.
     *
     * @since 1.0.0
     * @access public
     * @return array JS script handles.
     */
    public function get_script_depends()
    {
        return ['mwt-tabs-accordion-script'];
    }

    /**
     * Retrieve Widget Dependent CSS.
     *
     * @since 1.0.0
     * @access public
     * @return array CSS style handles.
     */
    public function get_style_depends()
    {
        return ['mwt-tabs-accordion-style'];
    }

    /**
     * Get widget name.
     *
     * Retrieve list widget name.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'mwt-tabs-accordion';
    }

    /**
     * Get widget title.
     *
     * Retrieve list widget title.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('MWT Tabs Accordion', 'mwt-addons-for-elementor');
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the list widget belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['mwt'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve image carousel widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-tabs';
    }

    /**
     * Get widget keywords.
     *
     * Retrieve the list of keywords the widget belongs to.
     *
     * @since 2.1.0
     * @access public
     *
     * @return array Widget keywords.
     */
    public function get_keywords()
    {
        return ['mwt', 'tabs', 'accordion'];
    }

    /**
     * Register list widget controls.
     *
     * Add input fields to allow the user to customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'tab_accordion_content_section',
            [
                'label' => esc_html__('Tabs', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'add_tab_1',
            [
                'label' => esc_html__('Add Tab', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HIDDEN,
                'label_on' => esc_html__('Yes', 'mwt-addons-for-elementor'),
                'label_off' => esc_html__('No', 'mwt-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'tab_name_1',
            [
                'label'       => __('Tab', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your tab name here', 'mwt-addons-for-elementor'),
                'default' => esc_html__('Tab Name #1', 'mwt-addons-for-elementor'),
                'label_block' => true,
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $accordion_repeater_1 = new \Elementor\Repeater();

        $accordion_repeater_1->add_control(
            'accordion_title_1',
            [
                'label'       => __('Title', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your title here', 'mwt-addons-for-elementor'),
                'label_block' => true,
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $accordion_repeater_1->add_control(
            'accordion_image_1',
            [
                'label' => esc_html__('Choose Image', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $accordion_repeater_1->add_control(
            'accordion_content_1',
            [
                'label' => esc_html__('Content', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        /* End repeater */
        $this->add_control(
            'accordion-list-1',
            [
                'label' => esc_html__('Accordion Items', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $accordion_repeater_1->get_controls(),
                'default' => [
                    [
                        'accordion_title_1' => esc_html__('Accordion #1', 'mwt-addons-for-elementor'),
                        'accordion_image_1' => '',
                        'accordion_content_1' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'mwt-addons-for-elementor'),
                    ],
                    [
                        'accordion_title_1' => esc_html__('Accordion #2', 'mwt-addons-for-elementor'),
                        'accordion_image_1' => '',
                        'accordion_content_1' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'mwt-addons-for-elementor'),
                    ],
                ],
                'title_field' => '{{{ accordion_title_1 }}}',
            ]
        );

        $this->add_control(
            'add_tab_2',
            [
                'label' => esc_html__('Add Tab', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HIDDEN,
                'label_on' => esc_html__('Yes', 'mwt-addons-for-elementor'),
                'label_off' => esc_html__('No', 'mwt-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'tab_name_2',
            [
                'label'       => __('Tab', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your tab name here', 'mwt-addons-for-elementor'),
                'default' => esc_html__('Tab Name #2', 'mwt-addons-for-elementor'),
                'separator' => 'before',
                'label_block' => true,
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $accordion_repeater_2 = new \Elementor\Repeater();

        $accordion_repeater_2->add_control(
            'accordion_title_2',
            [
                'label'       => __('Title', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your title here', 'mwt-addons-for-elementor'),
                'label_block' => true,
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $accordion_repeater_2->add_control(
            'accordion_image_2',
            [
                'label' => esc_html__('Choose Image', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $accordion_repeater_2->add_control(
            'accordion_content_2',
            [
                'label' => esc_html__('Content', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        /* End repeater */
        $this->add_control(
            'accordion-list-2',
            [
                'label' => esc_html__('Accordion Items', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $accordion_repeater_2->get_controls(),
                'default' => [
                    [
                        'accordion_title_2' => esc_html__('Accordion #1', 'mwt-addons-for-elementor'),
                        'accordion_image_2' => '',
                        'accordion_content_2' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'mwt-addons-for-elementor'),
                    ],
                    [
                        'accordion_title_2' => esc_html__('Accordion #2', 'mwt-addons-for-elementor'),
                        'accordion_image_2' => '',
                        'accordion_content_2' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'mwt-addons-for-elementor'),
                    ],
                ],
                'title_field' => '{{{ accordion_title_2 }}}',
            ]
        );

        $this->add_control(
            'add_tab_3',
            [
                'label' => esc_html__('Add Tab', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'mwt-addons-for-elementor'),
                'label_off' => esc_html__('No', 'mwt-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'tab_name_3',
            [
                'label'       => __('Tab', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your tab name here', 'mwt-addons-for-elementor'),
                'default' => esc_html__('Tab Name #3', 'mwt-addons-for-elementor'),
                'separator' => 'before',
                'label_block' => true,
                'ai' => [
                    'active' => false,
                ],
                'condition' => [
                    'add_tab_3' => 'yes',
                ]
            ]
        );

        $accordion_repeater_3 = new \Elementor\Repeater();

        $accordion_repeater_3->add_control(
            'accordion_title_3',
            [
                'label'       => __('Title', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your title here', 'mwt-addons-for-elementor'),
                'label_block' => true,
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $accordion_repeater_3->add_control(
            'accordion_image_3',
            [
                'label' => esc_html__('Choose Image', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $accordion_repeater_3->add_control(
            'accordion_content_3',
            [
                'label' => esc_html__('Content', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        /* End repeater */
        $this->add_control(
            'accordion-list-3',
            [
                'label' => esc_html__('Accordion Items', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $accordion_repeater_3->get_controls(),
                'default' => [
                    [
                        'accordion_title_3' => esc_html__('Accordion #1', 'mwt-addons-for-elementor'),
                        'accordion_image_3' => '',
                        'accordion_content_3' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'mwt-addons-for-elementor'),
                    ],
                    [
                        'accordion_title_3' => esc_html__('Accordion #2', 'mwt-addons-for-elementor'),
                        'accordion_image_3' => '',
                        'accordion_content_3' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'mwt-addons-for-elementor'),
                    ],
                ],
                'condition' => [
                    'add_tab_3' => 'yes',
                ],
                'title_field' => '{{{ accordion_title_3 }}}',
            ]
        );

        $this->add_control(
            'add_tab_4',
            [
                'label' => esc_html__('Add Tab', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'mwt-addons-for-elementor'),
                'label_off' => esc_html__('No', 'mwt-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'add_tab_3' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'tab_name_4',
            [
                'label'       => __('Tab', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your tab name here', 'mwt-addons-for-elementor'),
                'default' => esc_html__('Tab Name #4', 'mwt-addons-for-elementor'),
                'separator' => 'before',
                'label_block' => true,
                'ai' => [
                    'active' => false,
                ],
                'condition' => [
                    'add_tab_3' => 'yes',
                    'add_tab_4' => 'yes',
                ]
            ]
        );

        $accordion_repeater_4 = new \Elementor\Repeater();

        $accordion_repeater_4->add_control(
            'accordion_title_4',
            [
                'label'       => __('Title', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your title here', 'mwt-addons-for-elementor'),
                'label_block' => true,
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $accordion_repeater_4->add_control(
            'accordion_image_4',
            [
                'label' => esc_html__('Choose Image', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $accordion_repeater_4->add_control(
            'accordion_content_4',
            [
                'label' => esc_html__('Content', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        /* End repeater */
        $this->add_control(
            'accordion-list-4',
            [
                'label' => esc_html__('Accordion Items', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $accordion_repeater_4->get_controls(),
                'default' => [
                    [
                        'accordion_title_4' => esc_html__('Accordion #1', 'mwt-addons-for-elementor'),
                        'accordion_image_4' => '',
                        'accordion_content_4' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'mwt-addons-for-elementor'),
                    ],
                    [
                        'accordion_title_4' => esc_html__('Accordion #2', 'mwt-addons-for-elementor'),
                        'accordion_image_4' => '',
                        'accordion_content_4' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'mwt-addons-for-elementor'),
                    ],
                ],
                'condition' => [
                    'add_tab_3' => 'yes',
                    'add_tab_4' => 'yes',
                ],
                'title_field' => '{{{ accordion_title_4 }}}',
            ]
        );

        $this->add_control(
            'add_tab_5',
            [
                'label' => esc_html__('Add Tab', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'mwt-addons-for-elementor'),
                'label_off' => esc_html__('No', 'mwt-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'add_tab_3' => 'yes',
                    'add_tab_4' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'tab_name_5',
            [
                'label'       => __('Tab', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your tab name here', 'mwt-addons-for-elementor'),
                'default' => esc_html__('Tab Name #5', 'mwt-addons-for-elementor'),
                'label_block' => true,
                'separator' => 'before',
                'ai' => [
                    'active' => false,
                ],
                'condition' => [
                    'add_tab_3' => 'yes',
                    'add_tab_4' => 'yes',
                    'add_tab_5' => 'yes',
                ]
            ]
        );

        $accordion_repeater_5 = new \Elementor\Repeater();

        $accordion_repeater_5->add_control(
            'accordion_title_5',
            [
                'label'       => __('Title', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your title here', 'mwt-addons-for-elementor'),
                'label_block' => true,
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $accordion_repeater_5->add_control(
            'accordion_image_5',
            [
                'label' => esc_html__('Choose Image', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $accordion_repeater_5->add_control(
            'accordion_content_5',
            [
                'label' => esc_html__('Content', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        /* End repeater */
        $this->add_control(
            'accordion-list-5',
            [
                'label' => esc_html__('Accordion Items', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $accordion_repeater_5->get_controls(),
                'default' => [
                    [
                        'accordion_title_5' => esc_html__('Accordion #1', 'mwt-addons-for-elementor'),
                        'accordion_image_5' => '',
                        'accordion_content_5' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'mwt-addons-for-elementor'),
                    ],
                    [
                        'accordion_title_5' => esc_html__('Accordion #2', 'mwt-addons-for-elementor'),
                        'accordion_image_5' => '',
                        'accordion_content_5' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'mwt-addons-for-elementor'),
                    ],
                ],
                'condition' => [
                    'add_tab_3' => 'yes',
                    'add_tab_4' => 'yes',
                    'add_tab_5' => 'yes',
                ],
                'title_field' => '{{{ accordion_title_5 }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'accordion_content_section',
            [
                'label' => esc_html__('Accordion Options', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'accordion_icon',
            [
                'label'            => __('Icon', 'mwt-addons-for-elementor'),
                'type'             => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-chevron-right',
                    'library' => 'fa-solid',
                ],
                'recommended'      => [
                    'fa-solid'   => [
                        'chevron-right',
                    ],
                ],
                'skin'             => 'inline',
                'label_block'      => false,
            ]
        );

        $this->add_control(
            'accordion_icon_active',
            [
                'label'            => __('Icon Active', 'mwt-addons-for-elementor'),
                'type'             => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-chevron-down',
                    'library' => 'fa-solid',
                ],
                'recommended'      => [
                    'fa-solid'   => [
                        'chevron-down',
                    ],
                ],
                'skin'             => 'inline',
                'label_block'      => false,
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'tabs_style',
            [
                'label'     => __('Tabs', 'mwt-addons-for-elementor'),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'tabs_align',
            [
                'label'     => __('Alignment', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left' => [
                        'title' => __('Left', 'mwt-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center'     => [
                        'title' => __('Center', 'mwt-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'   => [
                        'title' => __('Right', 'mwt-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'tabs_typography',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_tabs a',
            ]
        );

        $this->start_controls_tabs(
            'tabs_style_tabs'
        );

        $this->start_controls_tab(
            'tabs_style_normal',
            [
                'label' => __('Normal', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'tabs_color',
            [
                'label'     => __('Text Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tabs_background_color',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'tabs_border',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_tabs a',
            ]
        );

        $this->add_control(
            'tabs_border_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs a'  => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_style_hover',
            [
                'label' => __('Hover', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'tabs_hover_color',
            [
                'label'     => __('Text Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tabs_background_hover_color',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'tabs_border_hover',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_tabs a:hover',
            ]
        );

        $this->add_control(
            'tabs_border_radius_hover',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs a:hover'  => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_style_active',
            [
                'label' => __('Active', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'tabs_active_color',
            [
                'label'     => __('Text Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs a.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tabs_background_active_color',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs a.active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'tabs_border_active',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_tabs a.active',
            ]
        );

        $this->add_control(
            'tabs_border_radius_active',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs a.active'  => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'tabs_shadow',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_tabs a',
            ]
        );

        $this->add_responsive_control(
            'tabs_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tabs_margin',
            [
                'label'      => __('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tabs_bottom_spacing',
            [
                'label'      => __('Tabs Bottom Spacing', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_tabs'  => 'margin-bottom: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'accordion_style',
            [
                'label'     => __('Accordion', 'mwt-addons-for-elementor'),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'accordion_spacing',
            [
                'label'       => __('Spacing', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::SLIDER,
                'size_units'  => ['px', 'em'],
                'range'       => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'label_block' => true,
                'selectors'   => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-item' => 'margin-bottom: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'accordion_title_style',
            [
                'label'     => __('Accordion Title', 'mwt-addons-for-elementor'),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'accordion_title_typography',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-title',
            ]
        );

        $this->start_controls_tabs(
            'accordion_title_style_tabs'
        );

        $this->start_controls_tab(
            'accordion_title_style_normal',
            [
                'label' => __('Normal', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'accordion_title_color',
            [
                'label'     => __('Text Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'accordion_title_background_color',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'accordion_title_style_hover',
            [
                'label' => __('Hover', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'accordion_title_hover_color',
            [
                'label'     => __('Text Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'accordion_title_background_hover_color',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'accordion_title_border_hover_color',
            [
                'label'     => __('Border Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'accordion_title_style_active',
            [
                'label' => __('Active', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'accordion_title_active_color',
            [
                'label'     => __('Text Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title.show' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'accordion_title_background_active_color',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title.show' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'accordion_title_border_active_color',
            [
                'label'     => __('Border Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title.show' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'accordion_title_border',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-title',
            ]
        );

        $this->add_control(
            'accordion_title_border_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title'  => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'accordion_title_shadow',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-title',
            ]
        );

        $this->add_responsive_control(
            'accordion_title_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'accordion_title_margin',
            [
                'label'      => __('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'accordion_icon_style',
            [
                'label'     => __('Accordion Icon', 'mwt-addons-for-elementor'),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'accordion_icon_size',
            [
                'label' => esc_html__('Size', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-icons-wrap span' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'accordion_icon_style_tabs'
        );

        $this->start_controls_tab(
            'accordion_icon_style_normal',
            [
                'label' => __('Normal', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'accordion_icon_color',
            [
                'label'     => __('Icon Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-icons-wrap span i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-icons-wrap span svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'accordion_icon_background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-icons-wrap span',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'accordion_icon_style_hover',
            [
                'label' => __('Hover', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'accordion_icon_hover_color',
            [
                'label'     => __('Icon Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title:hover .mwt-tabs-accordion_accordion-icons-wrap span i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title:hover .mwt-tabs-accordion_accordion-icons-wrap span svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'accordion_icon_hover_background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-title:hover .mwt-tabs-accordion_accordion-icons-wrap span',
            ]
        );

        $this->add_control(
            'accordion_icon_border_hover_color',
            [
                'label'     => __('Border Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title:hover .mwt-tabs-accordion_accordion-icons-wrap span' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'accordion_icon_style_active',
            [
                'label' => __('Active', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'accordion_icon_active_color',
            [
                'label'     => __('Icon Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title.show .mwt-tabs-accordion_accordion-icons-wrap span i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title.show .mwt-tabs-accordion_accordion-icons-wrap span svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'accordion_icon_active_background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-title.show .mwt-tabs-accordion_accordion-icons-wrap span',
            ]
        );

        $this->add_control(
            'accordion_icon_border_active_color',
            [
                'label'     => __('Border Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-title.show .mwt-tabs-accordion_accordion-icons-wrap span' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'accordion_icon_border',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-icons-wrap span',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'accordion_icon_border_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-icons-wrap span'  => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'accordion_icon_shadow',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-icons-wrap span',
            ]
        );

        $this->add_responsive_control(
            'accordion_icon_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-icons-wrap span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'accordion_content_style',
            [
                'label'     => __('Accordion Content', 'mwt-addons-for-elementor'),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'accordion_content_gap',
            [
                'label' => esc_html__('Gap', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 60,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_side-item' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'accordion_content_background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-content',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'accordion_content_border',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-content',
            ]
        );

        $this->add_control(
            'accordion_content_border_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-content'  => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'accordion_content_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'accordion_content_shadow',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-content',
            ]
        );

        $this->add_control(
            'accordion_content_media_options',
            [
                'label' => esc_html__('Media', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'exclude' => ['custom'],
                'include' => [],
                'default' => 'full',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'accordion_content_image_border',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_side-item-media img',
            ]
        );

        $this->add_control(
            'accordion_content_image_border_radius',
            [
                'label'      => __('Image Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-tabs-accordion_side-item-media img'  => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'accordion_content_content_options',
            [
                'label' => esc_html__('Content', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'accordion_content_typography',
                'selector' => '{{WRAPPER}} .mwt-tabs-accordion_accordion-content',
            ]
        );

        $this->add_control(
            'accordion_content_color',
            [
                'label'     => __('Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-tabs-accordion_accordion-content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render list widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>

        <div class="mwt-tabs-accordion_container">
            <div class="mwt-tabs-accordion_tabs">
                <?php
                $i = 1;
                while ($i <= 5) {
                    if (!empty($settings['tab_name_' . $i . '']) && $settings['add_tab_' . $i . ''] === 'yes') : ?>
                        <a href="#" class="mwt-tabs-accordion_tab"> <?php echo esc_html($settings['tab_name_' . $i . '']); ?></a>
                <?php endif;
                    $i++;
                }; ?>
            </div>
            <div class="mwt-tabs-accordion_tabs-content">
                <?php
                $accordion_icon = isset($settings['accordion_icon']) ? $settings['accordion_icon'] : '';
                $accordion_icon_active = isset($settings['accordion_icon_active']) ? $settings['accordion_icon_active'] : '';

                $i = 1;
                while ($i <= 5) {
                    if (!empty($settings['tab_name_' . $i . '']) && $settings['add_tab_' . $i . ''] === 'yes') : ?>
                        <div class="mwt-tabs-accordion_tab-item">
                            <div class="mwt-tabs-accordion_accordion-wrap">
                                <?php foreach ($settings['accordion-list-' . $i . ''] as $item) { ?>
                                    <div class="mwt-tabs-accordion_accordion-item">
                                        <a class="mwt-tabs-accordion_accordion-title" href="#"><?php echo esc_html($item['accordion_title_' . $i . '']); ?>
                                            <span class="mwt-tabs-accordion_accordion-icons-wrap">
                                                <span class="mwt-tabs-accordion_accordion-icon">
                                                    <?php if ($accordion_icon) :
                                                        \Elementor\Icons_Manager::render_icon($accordion_icon, ['aria-hidden' => 'true']);
                                                    endif; ?>
                                                </span>
                                                <span class="mwt-tabs-accordion_accordion-icon-active">
                                                    <?php if ($accordion_icon_active) :
                                                        \Elementor\Icons_Manager::render_icon($accordion_icon_active, ['aria-hidden' => 'true']);
                                                    endif; ?>
                                                </span>
                                            </span>
                                        </a>
                                        <div class="mwt-tabs-accordion_accordion-content">
                                            <div class="mwt-tabs-accordion_side-item">
                                                <div class="mwt-tabs-accordion_side-item-media">
                                                    <?php
                                                    $image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['accordion_image_' . $i . '']['id'], 'thumbnail', $settings);
                                                    if (!$image_url && isset($item['accordion_image_' . $i . '']['url'])) {
                                                        $image_url = $item['accordion_image_' . $i . '']['url'];
                                                    }
                                                    if (!empty($item['accordion_title_' . $i . ''])) {
                                                        $image_alt = $item['accordion_title_' . $i . ''];
                                                    } else {
                                                        $image_alt = 'This is a title';
                                                    }
                                                    $image_html = '<img src="' . esc_attr($image_url) . '" alt="' . esc_attr($image_alt) . '" />';
                                                    echo wp_kses_post($image_html);
                                                    ?>
                                                </div>
                                                <div class="mwt-tabs-accordion_side-item-content">
                                                    <?php echo $item['accordion_content_' . $i . '']; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php }; ?>
                            </div>
                        </div>
                <?php endif;
                    $i++;
                } ?>
            </div>
        </div>
<?php }
}
