<?php

/**
 * Widget Theme meta view file
 *
 * @package Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

// if our theme is not active - return
if (!function_exists('energy_get_theme_meta')) {
	return;
}

//meta
$mwt_meta = energy_get_theme_meta();

$mwt_center_class = (!empty($mwt_text_center)) ? ' text-center' : '';

echo wp_kses_post($mwt_args['before_widget']);
echo '<div class="widget-theme-meta-default ' . esc_attr($mwt_css_class . $mwt_center_class) . '">';
if ($mwt_title) {
	echo wp_kses_post($mwt_args['before_title'] . $mwt_title . $mwt_args['after_title']);
}
if ($mwt_image_uri) {
	echo '<div class="theme-meta-img wp-block-image"><img src="' . esc_url($mwt_image_uri) . '" alt="' . esc_attr($mwt_title) . '"></div>';
}
if ($mwt_sub_title) {
	echo '<p class="sub-title">' . wp_kses_post(energy_get_copyright_text($mwt_sub_title)) . '</p><!-- .sub-title-->';
}

if (
	!empty($mwt_meta)
) :

	if (!empty($mwt_show_address) || !empty($mwt_show_phone) || !empty($mwt_show_phone_2) || !empty($mwt_show_email) || !empty($mwt_show_email_2) || !empty($mwt_show_opening_hours)) :
?>
		<div class="theme-meta greylinks">
			<?php
			if (!empty($mwt_meta['address']) && !empty($mwt_show_address)) :
			?>
				<span class="icon-inline">
					<?php energy_icon('map-marker'); ?>
					<span>
						<?php if (!empty($mwt_meta['address_label'])) : ?>
							<strong><?php echo wp_kses_post($mwt_meta['address_label']); ?></strong>
						<?php endif; ?>
						<?php echo wp_kses_post($mwt_meta['address']); ?>
					</span>
				</span>
			<?php
			endif; //address
			if ((!empty($mwt_meta['phone']) && !empty($mwt_show_phone)) || (!empty($mwt_meta['phone_2']) && !empty($mwt_show_phone_2))) :
			?>
				<span class="icon-inline">
					<?php energy_icon('phone'); ?>
					<span>
						<?php
						if (!empty($mwt_meta['phone']) && !empty($mwt_show_phone)) :
							$phone_from_meta = $mwt_meta['phone'];
							$print_phone = preg_replace("/[^0-9]/", '', $phone_from_meta); ?>
							<span>
								<?php if (!empty($mwt_meta['phone_label'])) : ?>
									<strong><?php echo wp_kses_post($mwt_meta['phone_label']); ?></strong>
								<?php endif; ?>
								<a href="tel:<?php echo esc_attr($print_phone); ?>"><?php echo wp_kses_post($mwt_meta['phone']); ?></a>
							</span>
							<br>
						<?php
						endif; //phone
						if (!empty($mwt_meta['phone_2']) && !empty($mwt_show_phone_2)) :
							$phone_2_from_meta = $mwt_meta['phone_2'];
							$print_phone_2 = preg_replace("/[^0-9]/", '', $phone_2_from_meta);
						?>
							<span>
								<?php if (!empty($mwt_meta['phone_2_label'])) : ?>
									<strong><?php echo wp_kses_post($mwt_meta['phone_2_label']); ?></strong>
								<?php endif; ?>
								<a href="tel:<?php echo esc_attr($print_phone_2); ?>"><?php echo wp_kses_post($mwt_meta['phone_2']); ?></a>
							</span>
						<?php endif; //phone_2 
						?>
					</span>
				</span>
			<?php
			endif;

			if (!empty($mwt_meta['email']) && !empty($mwt_show_email) || !empty($mwt_meta['email_2']) && !empty($mwt_show_email_2)) :
			?>
				<span class="icon-inline">
					<?php energy_icon('email'); ?>
					<span>
						<?php
						if (!empty($mwt_meta['email']) && !empty($mwt_show_email)) :
						?>
							<span>
								<?php if (!empty($mwt_meta['email_label'])) : ?>
									<strong><?php echo wp_kses_post($mwt_meta['email_label']); ?></strong>
								<?php endif; ?>
								<a href="mailto:<?php echo esc_attr($mwt_meta['email']); ?>"><?php echo wp_kses_post($mwt_meta['email']); ?></a>
							</span>
							<br>
						<?php endif; //email
						if (!empty($mwt_meta['email_2']) && !empty($mwt_show_email_2)) : ?>
							<span>
								<?php if (!empty($mwt_meta['email_2_label'])) : ?>
									<strong><?php echo wp_kses_post($mwt_meta['email_2_label']); ?></strong>
								<?php endif; ?>
								<a href="mailto:<?php echo esc_attr($mwt_meta['email_2']); ?>"><?php echo wp_kses_post($mwt_meta['email_2']); ?></a>
							</span>
						<?php endif; //email_2 
						?>
					</span>
				</span>
			<?php
			endif;

			if (!empty($mwt_meta['opening_hours']) && !empty($mwt_show_opening_hours)) :
			?>
				<span class="icon-inline">
					<span>
						<?php if (!empty($mwt_meta['opening_hours_label'])) : ?>
							<strong><?php echo wp_kses_post($mwt_meta['opening_hours_label']); ?></strong>
						<?php endif; ?>
						<span><?php echo wp_kses_post($mwt_meta['opening_hours']); ?></span>
					</span>
				</span>
			<?php
			endif; //opening_hours
			?>
		</div><!-- .theme-meta -->
	<?php
	endif;
endif; //! empty meta
if (
	(!empty($mwt_show_meta_facebook)
		|| !empty($mwt_show_meta_twitter)
		|| !empty($mwt_show_meta_instagram)
		|| !empty($mwt_show_meta_linkedin)
		|| !empty($mwt_show_meta_youtube)
		|| !empty($mwt_show_meta_pinterest)
		|| !empty($mwt_show_meta_github))
	&& function_exists('energy_link_theme_meta_widget')
) :
	?>
	<?php
	$mwt_twitter    = energy_option('meta_twitter');
	$mwt_facebook   = energy_option('meta_facebook');
	$mwt_linkedin   = energy_option('meta_linkedin');
	$mwt_youtube    = energy_option('meta_youtube');
	$mwt_instagram  = energy_option('meta_instagram');
	$mwt_pinterest  = energy_option('meta_pinterest');
	$mwt_github     = energy_option('meta_github');

	if (
		!empty($mwt_facebook)
		||
		!empty($mwt_twitter)
		||
		!empty($mwt_youtube)
		||
		!empty($mwt_instagram)
		||
		!empty($mwt_pinterest)
		||
		!empty($mwt_linkedin)
		||
		!empty($mwt_github)
	) :

		echo '<span class="social-links">';

		if (!empty($mwt_twitter) && !empty($mwt_show_meta_twitter)) :
			energy_link_theme_meta_widget('twitter', $mwt_twitter);
		endif;

		if (!empty($mwt_facebook) && !empty($mwt_show_meta_facebook)) :
			energy_link_theme_meta_widget('facebook', $mwt_facebook);
		endif;

		if (!empty($mwt_instagram) && !empty($mwt_show_meta_instagram)) :
			energy_link_theme_meta_widget('instagram', $mwt_instagram);
		endif;

		if (!empty($mwt_youtube) && !empty($mwt_show_meta_youtube)) :
			energy_link_theme_meta_widget('youtube', $mwt_youtube);
		endif;

		if (!empty($mwt_pinterest) && !empty($mwt_show_meta_pinterest)) :
			energy_link_theme_meta_widget('pinterest', $mwt_pinterest);
		endif;

		if (!empty($mwt_linkedin) && !empty($mwt_show_meta_linkedin)) :
			energy_link_theme_meta_widget('linkedin', $mwt_linkedin);
		endif;

		if (!empty($mwt_github) && !empty($mwt_show_meta_github)) :
			energy_link_theme_meta_widget('github-circle', $mwt_github);
		endif;

		echo '</span><!--.social-links-->';

	endif;
	?>
<?php endif; //social_links 
?>
</div><!-- .widget-theme-meta-default -->
<?php
echo wp_kses_post($mwt_args['after_widget']);
