<?php

/**
 * Widget API: MWT_Widget_Theme_Spacer class
 *
 * @package Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!class_exists('MWT_Widget_Theme_Spacer')) :

	class MWT_Widget_Theme_Spacer extends WP_Widget
	{

		/**
		 * Sets up a new Recent Posts widget instance.
		 *
		 * @since 0.0.1
		 */
		public function __construct()
		{
			$mwt_widget_ops = array(
				'classname'                   => 'widget_theme_spacer',
				'description'                 => esc_html__('Theme spacer from customizer settings.', 'mwt-widgets'),
				'customize_selective_refresh' => true,
			);
			parent::__construct('theme-spacer', esc_html__('Theme Spacer', 'mwt-widgets'), $mwt_widget_ops);
			$this->alt_option_name = 'widget_theme_spacer';
		}

		/**
		 * Outputs the content for the current Custom Posts widget instance.
		 *
		 * @param array $mwt_args Display arguments including 'before_title', 'after_title',
		 *                        'before_widget', and 'after_widget'.
		 * @param array $mwt_instance Settings for the current Custom Posts widget instance.
		 */
		public function widget($mwt_args, $mwt_instance)
		{
			if (!isset($mwt_args['widget_id'])) {
				$mwt_args['widget_id'] = $this->id;
			}

			$mwt_title = (!empty($mwt_instance['title'])) ? $mwt_instance['title'] : '';

			/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
			$mwt_title = apply_filters('widget_title', $mwt_title, $mwt_instance, $this->id_base);

			$mwt_sub_title   = (!empty($mwt_instance['sub_title'])) ? $mwt_instance['sub_title'] : '';
			$mwt_text_center = isset($mwt_instance['text_center']) ? $mwt_instance['text_center'] : false;
			$mwt_layout      = (!empty($mwt_instance['layout'])) ? esc_attr($mwt_instance['layout']) : 'default';
			$mwt_pt          = (!empty($mwt_instance['pt'])) ? esc_attr($mwt_instance['pt']) : '';
			$mwt_pb          = (!empty($mwt_instance['pb'])) ? esc_attr($mwt_instance['pb']) : '';
			$mwt_css_class   = (!empty($mwt_instance['css_class'])) ? sanitize_text_field($mwt_instance['css_class']) : '';

			$mwt_filepath = MWT_WIDGETS_PLUGIN_PATH . 'widgets/spacer/views/default.php';

			if (file_exists($mwt_filepath)) {
				include $mwt_filepath;
			} else {
				esc_html_e('View not found: ', 'mwt-widgets');
				echo '<strong>' . esc_html($mwt_filepath) . '</strong>';
			}
		}

		/**
		 * Handles updating the settings for the current Recent Posts widget instance.
		 *
		 * @param array $mwt_new_instance New settings for this instance as input by the user via
		 *                            WP_Widget::form().
		 * @param array $mwt_old_instance Old settings for this instance.
		 *
		 * @return array Updated settings to save.
		 */
		public function update($mwt_new_instance, $mwt_old_instance)
		{
			$mwt_instance                = $mwt_old_instance;
			$mwt_instance['title']       = sanitize_text_field($mwt_new_instance['title']);
			$mwt_instance['sub_title']   = sanitize_text_field($mwt_new_instance['sub_title']);
			$mwt_instance['layout']      = esc_attr($mwt_new_instance['layout']);
			$mwt_instance['pt']          = esc_attr($mwt_new_instance['pt']);
			$mwt_instance['pb']          = esc_attr($mwt_new_instance['pb']);
			$mwt_instance['text_center'] = isset($mwt_new_instance['text_center']) ? (bool) $mwt_new_instance['text_center'] : false;
			$mwt_instance['css_class']   = sanitize_text_field($mwt_new_instance['css_class']);

			return $mwt_instance;
		}

		/**
		 * Outputs the settings form for the Recent Posts widget.
		 *
		 * @param array $mwt_instance Current settings.
		 */
		public function form($mwt_instance)
		{
			$mwt_title       = isset($mwt_instance['title']) ? esc_attr($mwt_instance['title']) : '';
			$mwt_sub_title   = isset($mwt_instance['sub_title']) ? esc_attr($mwt_instance['sub_title']) : '';
			$mwt_layout      = isset($mwt_instance['layout']) ? esc_attr($mwt_instance['layout']) : 'default';
			$mwt_pt          = isset($mwt_instance['pt']) ? esc_attr($mwt_instance['pt']) : '';
			$mwt_pb          = isset($mwt_instance['pb']) ? esc_attr($mwt_instance['pb']) : '';
			$mwt_text_center = isset($mwt_instance['text_center']) ? (bool) $mwt_instance['text_center'] : false;
			$mwt_css_class   = isset($mwt_instance['css_class']) ? sanitize_text_field($mwt_instance['css_class']) : '';
?>
			<p>
				<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'mwt-widgets'); ?></label>
				<input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($mwt_title); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr($this->get_field_id('sub_title')); ?>"><?php esc_html_e('Sub Title:', 'mwt-widgets'); ?></label>
				<textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('sub_title')); ?>" name="<?php echo esc_attr($this->get_field_name('sub_title')); ?>"><?php echo esc_html($mwt_sub_title); ?></textarea>
			</p>

			<p>
				<label for="<?php echo esc_attr($this->get_field_id('layout')); ?>"><?php esc_html_e('Widgets layout:', 'mwt-widgets'); ?></label>
				<select name="<?php echo esc_attr($this->get_field_name('layout')); ?>" id="<?php echo esc_attr($this->get_field_id('layout')); ?>" class="widefat">
					<option value="default" <?php selected($mwt_layout, 'default'); ?>><?php esc_html_e('Spacer', 'mwt-widgets'); ?></option>
					<option value="hr" <?php selected($mwt_layout, 'hr'); ?>><?php esc_html_e('Horizontal Rule (hr)', 'mwt-widgets'); ?></option>
				</select>
			</p>


			<p>
				<label for="<?php echo esc_attr($this->get_field_id('pt')); ?>"><?php esc_html_e('Top space:', 'mwt-widgets'); ?></label>
				<select name="<?php echo esc_attr($this->get_field_name('pt')); ?>" id="<?php echo esc_attr($this->get_field_id('pt')); ?>" class="widefat">
					<option value="" <?php selected($mwt_pt, ''); ?>><?php esc_html_e('None', 'mwt-widgets'); ?></option>
					<option value="05" <?php selected($mwt_pt, '05'); ?>><?php esc_html_e('0.5em', 'mwt-widgets'); ?></option>
					<option value="1" <?php selected($mwt_pt, '1'); ?>><?php esc_html_e('1em', 'mwt-widgets'); ?></option>
					<option value="2" <?php selected($mwt_pt, '2'); ?>><?php esc_html_e('2em', 'mwt-widgets'); ?></option>
					<option value="3" <?php selected($mwt_pt, '3'); ?>><?php esc_html_e('3em', 'mwt-widgets'); ?></option>
					<option value="4" <?php selected($mwt_pt, '4'); ?>><?php esc_html_e('4em', 'mwt-widgets'); ?></option>
					<option value="5" <?php selected($mwt_pt, '5'); ?>><?php esc_html_e('5em', 'mwt-widgets'); ?></option>
				</select>
			</p>


			<p>
				<label for="<?php echo esc_attr($this->get_field_id('pb')); ?>"><?php esc_html_e('Bottom space:', 'mwt-widgets'); ?></label>
				<select name="<?php echo esc_attr($this->get_field_name('pb')); ?>" id="<?php echo esc_attr($this->get_field_id('pb')); ?>" class="widefat">
					<option value="" <?php selected($mwt_pb, ''); ?>><?php esc_html_e('None', 'mwt-widgets'); ?></option>
					<option value="05" <?php selected($mwt_pb, '05'); ?>><?php esc_html_e('0.5em', 'mwt-widgets'); ?></option>
					<option value="1" <?php selected($mwt_pb, '1'); ?>><?php esc_html_e('1em', 'mwt-widgets'); ?></option>
					<option value="2" <?php selected($mwt_pb, '2'); ?>><?php esc_html_e('2em', 'mwt-widgets'); ?></option>
					<option value="3" <?php selected($mwt_pb, '3'); ?>><?php esc_html_e('3em', 'mwt-widgets'); ?></option>
					<option value="4" <?php selected($mwt_pb, '4'); ?>><?php esc_html_e('4em', 'mwt-widgets'); ?></option>
					<option value="5" <?php selected($mwt_pb, '5'); ?>><?php esc_html_e('5em', 'mwt-widgets'); ?></option>
				</select>
			</p>

			<p>
				<input class="checkbox" type="checkbox" <?php checked($mwt_text_center); ?> id="<?php echo esc_attr($this->get_field_id('text_center')); ?>" name="<?php echo esc_attr($this->get_field_name('text_center')); ?>" />
				<label for="<?php echo esc_attr($this->get_field_id('text_center')); ?>"><?php esc_html_e('Center alignment', 'mwt-widgets'); ?></label>
			</p>

			<p>
				<label for="<?php echo esc_attr($this->get_field_id('css_class')); ?>"><?php esc_html_e('Custom CSS class:', 'mwt-widgets'); ?></label>
				<input class="widefat" id="<?php echo esc_attr($this->get_field_id('css_class')); ?>" name="<?php echo esc_attr($this->get_field_name('css_class')); ?>" type="text" value="<?php echo esc_attr($mwt_css_class); ?>" />
			</p>
<?php
		}
	}

endif; //class_exists

if (!function_exists('energy_theme_register_widget_theme_spacer')) :
	function energy_theme_register_widget_theme_spacer()
	{
		register_widget('MWT_Widget_Theme_Spacer');
	}
endif;
add_action('widgets_init', 'energy_theme_register_widget_theme_spacer');
