<?php if (!defined('UB')) die('Forbidden');

$limits = apply_filters('ub_ext_backups_schedule_lifetime_limits', array(
	'monthly' => 12,
	'weekly' => 4,
	'daily' => 7,
));

$sub_options = array(
	'type' => 'multi-picker',
	'label' => false,
	'desc'  => false,
	'show_borders' => true,
	'picker' => array(
		'interval' => array(
			'label'   => __('Interval', 'ub'),
			'type'    => 'radio',
			'inline'  => true,
			'choices' => array(
				''  => __('Disabled', 'ub'),
				'monthly' => __('Monthly', 'ub'),
				'weekly' => __('Weekly', 'ub'),
				'daily' => __('Daily', 'ub'),
			),
			'desc'    => __('Select how often do you want to backup your website.', 'ub'),
		)
	),
	'choices' => array(
		'monthly' => array(
			'lifetime' => array(
				'type' => 'short-slider',
				'label' => __('Age Limit', 'ub'),
				'desc' => __('Age limit of backups in months', 'ub'),
				'value' => $limits['monthly'],
				'properties' => array(
					'min' => 1,
					'max' => $limits['monthly'],
					'grid_snap' => true,
				),
			),
		),
		'weekly' => array(
			'lifetime' => array(
				'type' => 'short-slider',
				'label' => __('Age Limit', 'ub'),
				'desc' => __('Age limit of backups in weeks', 'ub'),
				'value' => $limits['weekly'],
				'properties' => array(
					'min' => 1,
					'max' => $limits['weekly'],
					'grid_snap' => true,
				),
			),
		),
		'daily' => array(
			'lifetime' => array(
				'type' => 'short-slider',
				'label' => __('Age Limit', 'ub'),
				'desc' => __('Age limit of backups in days', 'ub'),
				'value' => $limits['daily'],
				'properties' => array(
					'min' => 1,
					'max' => $limits['daily'],
					'grid_snap' => true,
				),
			),
		),
	),
);

$options = array();

if (ub_ext_backups_current_user_can_full()) {
	$options['full'] = array(
		'type'    => 'tab',
		'title'   => __( 'Full Backup', 'ub' ),
		'options' => array(
			'full' => $sub_options,
		),
	);
}

$options['content'] = array(
	'type' => 'tab',
	'title' => __('Content Backup', 'ub'),
	'options' => array(
		'content' => $sub_options,
	),
);
