<?php
/*
Plugin Name: Unyson Backup
Description: Standalone Unyson Backup Extension extended
Version:     0.0.3
Author:      MWTemplates
Author URI:  https://modernwebtemplates.com/
License:     GPLv2 or later
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! defined( 'UB' ) ) {
	define( 'UB', true );
}


define( 'UNYSON_BACKUP_PLUGIN_ASSETS_URL', plugin_dir_url( __FILE__ ) . 'backups' );
define( 'UNYSON_BACKUP_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'UNYSON_BACKUP_VERSION', '0.0.1' );


require_once UNYSON_BACKUP_PLUGIN_PATH . 'backups/helpers.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'backups/hooks.php';

require_once UNYSON_BACKUP_PLUGIN_PATH . 'class-ub-access-key.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'class-ub-cache.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'class-ub-callback.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'class-ub-wp-list-table.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'class-ub-extension.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'class-ub-wp-filesystem.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'class-ub-type.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'class-ub-type-register.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'backups/class-ub-extension-backups.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'functions.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'backups/extensions/backups-demo/class-ub-extension-backups-demo.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'class-tgm-plugin-activation.php';
require_once UNYSON_BACKUP_PLUGIN_PATH . 'plugins-autho-install.php';

if( ! function_exists( 'ub_backup_extension_init_action' ) ) :
	function ub_backup_extension_init_action() {
		global $ub_global_backup;
		$ub_global_backup = new UB_Extension_Backups(array(
			'rel_path' => '',
			'path' => UNYSON_BACKUP_PLUGIN_PATH . 'backups/',
			'uri' => UNYSON_BACKUP_PLUGIN_ASSETS_URL,
			'parent' => '',
			'depth' => '',
			'customizations_locations' => array(),
		));

		global $ub_global_backup_demo;
		$ub_global_backup_demo = new UB_Extension_Backups_Demo(array(
			'rel_path' => '',
			'path' => UNYSON_BACKUP_PLUGIN_PATH . 'backups/extensions/backups-demo/',
			'uri' => UNYSON_BACKUP_PLUGIN_ASSETS_URL,
			'parent' => '',
			'depth' => '',
			'customizations_locations' => array(),
		));


		$ub_global_backup->_call_init(new UB_Access_Key('ub_extensions'));
		$ub_global_backup_demo->init();
	}
endif;
add_action( 'plugins_loaded', 'ub_backup_extension_init_action' );
