<?php

/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if (post_password_required()) {
	return;
}

?>

<div id="comments" class="comments-area">
	<div class="comments-wrap">
		<?php
		// You can start editing here -- including this comment!
		if (have_comments()) :
		?>
			<h3 class="comments-title">
				<?php
				$energy_comments_number = get_comments_number();
				//this option does not exists. Leave this code if we'll nedd post title in future
				if (energy_option('blog_single_show_post_title_in_comments', '')) :
					if ('1' === $energy_comments_number) {
						/* translators: %s: post title */
						printf(esc_html_x('One Reply to &ldquo;%s&rdquo;', 'comments title', 'energy'), esc_html(get_the_title()));
					} else {
						printf(
							esc_html(
								/* translators: 1: number of comments, 2: post title */
								_nx(
									'%1$s Reply to &ldquo;%2$s&rdquo;',
									'%1$s Replies to &ldquo;%2$s&rdquo;',
									$energy_comments_number,
									'comments title',
									'energy'
								)
							),
							esc_html(
								number_format_i18n(
									$energy_comments_number
								)
							),
							esc_html(get_the_title())
						);
					}
				else :
					if ('1' === $energy_comments_number) {
						printf(esc_html_x('One comment on &ldquo;%s&rdquo;', 'comments title', 'energy'), esc_html(get_the_title()));
					} else {
						printf(
							esc_html(
								/* translators: 1: number of comments */
								_nx(
									'%1$s comment on &ldquo;%2$s&rdquo;',
									'%1$s comments on &ldquo;%2$s&rdquo;',
									$energy_comments_number,
									'comments title',
									'energy'
								)
							),
							esc_html(
								number_format_i18n(
									$energy_comments_number
								)
							),
							esc_html(get_the_title())
						);
					}
				endif;
				?>
			</h3>

			<ol class="comment-list">
				<?php
				wp_list_comments(
					array(
						'avatar_size' => 70,
						'style'       => 'ol',
						'short_ping'  => true,
						'reply_text'  => energy_icon('reply', true) . ' ' . esc_html__('Reply', 'energy'),
						'login_text'  => energy_icon('reply', true) . ' ' . esc_html__('Login to Reply', 'energy'),
					)
				);
				?>
			</ol>

		<?php
			the_comments_pagination(
				energy_get_the_posts_pagination_atts()
			);

		endif; // Check for have_comments().
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if (!comments_open() && get_comments_number() && post_type_supports(get_post_type(), 'comments')) :
		?>
			<p class="no-comments"><?php esc_html_e('Comments are closed.', 'energy'); ?></p>
		<?php
		endif; //comments_open
		?>
		<?php
		//placehoders for fields
		$energy_commenter = wp_get_current_commenter();
		comment_form(
			array(
				'comment_notes_before' => '',
				'title_reply'   => energy_option('blog_single_comments_title_reply', esc_html__('Write your comment', 'energy')),
				'fields'        => array(

					'author' => '<p class="comment-form-author"><label for="author">' . esc_html__('Full name', 'energy') . ' <span class="required">*</span></label> ' .
						'<input id="author" name="author" type="text" value="' . esc_attr($energy_commenter['comment_author']) . '" size="30" maxlength="245" required="required" /></p>',
					'email'  => '<p class="comment-form-email"><label for="email">' . esc_html__('Email address', 'energy') . ' <span class="required">*</span></label> ' .
						'<input id="email" name="email" type="email" value="' . esc_attr($energy_commenter['comment_author_email']) . '" size="30" maxlength="100" aria-describedby="email-notes" required="required" /></p>',
					'url'    => '',
				),
				'comment_field' => '<p class="comment-form-comment"><label for="comment">' . esc_html_x('Comment...', 'noun', 'energy') . '</label> <textarea id="comment" name="comment" cols="45" rows="2" maxlength="65525" required="required"></textarea></p>',
				'label_submit'         => esc_html__('Send Comment', 'energy'),
				'submit_button' => '<button type="submit" name="%1$s" id="%2$s" class="theme_button color min_width_button">%4$s</button>',
			)
		);
		?>
	</div>
	<!--.comments-wrap -->
</div><!-- #comments -->