<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$energy_body_itemtype = energy_get_body_schema_itemtype();

//light or dark version
$energy_main_version = energy_option('main_version');

?>
<!doctype html>
<html <?php language_attributes(); ?> class="no-js-disabled<?php echo is_customize_preview() ? ' customize-preview' : ''; ?>">

<head>
	<meta charset="<?php bloginfo('charset'); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<?php wp_head(); ?>


</head>

<body id="body" <?php body_class(); ?> itemtype="https://schema.org/<?php echo esc_attr($energy_body_itemtype); ?>" itemscope="itemscope" <?php energy_animated_elements_markup(); ?>>
	<?php
	if (function_exists('wp_body_open')) {
		wp_body_open();
	}

	get_template_part('template-parts/header/header-preloader');

	/**
	 * Fires at the top of whole web page before the header.
	 *
	 * @since WBPlank 0.0.1
	 */
	do_action('energy_action_before_header');

	?>
	<div id="search_dropdown">
		<?php get_search_form(); ?>
	</div><!-- #search_dropdown -->
	<button id="search_modal_close" class="nav-btn" aria-controls="search_dropdown" aria-expanded="true" aria-label="<?php esc_attr_e('Search Toggler', 'energy'); ?>">
		<span></span>
	</button>
	<div id="login_dropdown" class="modalLoginWrap">
		<?php
		$energy_logo_background     = energy_option('header_logo_background', '');
		?>
		<div class="modal modal-login active">
			<div class="img-section" <?php echo (!empty($energy_logo_background)) ? 'style="background-image: url(' . esc_url($energy_logo_background) . ');"' : ''; ?>>
				<p class="fs-14 fw-500"><?php echo esc_html__('New user?', 'energy') ?></p>
				<h4><?php echo esc_html__('Register', 'energy') ?></h4>
				<button class="button" data-toggle="modal-registration"><?php echo esc_html__('Sign up', 'energy') ?></button>
			</div>
			<div class="form-section">
				<h4 class="mb-1"><?php echo esc_html__('Log in', 'energy') ?></h4>
				<?php
				if (!is_user_logged_in()) :
					wp_login_form(array(
						'label_username' => esc_html__('Email address', 'energy'),
						'label_password' => esc_html__('Password', 'energy'),
						'label_remember' => esc_html__('Remember Me', 'energy'),
						'label_log_in' => esc_html__('Sign in', 'energy'),
						'remember' => esc_html__('Remember me', 'energy'),
					));

				else :
					$html = '<a href="' . esc_url(wp_logout_url()) . '" class="button">' . esc_html__('Log out', 'energy') . '</a>';
					if (current_user_can('read')) {
						$html .= ' <a href="' . admin_url() . '" class="button is-dark mt-1">' . esc_html__('Site Admin', 'energy') . '</a>';
					}
					echo wp_kses_post($html);
				endif; //is_user_logged_in
				?>
				<?php if (!is_user_logged_in()) : ?>
					<a class="mt-2" href="<?php echo esc_url(wp_lostpassword_url()); ?>"><?php esc_html_e('Forgot password?', 'energy'); ?></a>
				<?php endif; ?>
			</div>
		</div>
		<div class="modal modal-registration">
			<div class="form-section">
				<h4 class="mb-1"><?php echo esc_html__('Registration', 'energy') ?></h4>
				<?php
				do_action('user_registration_form');
				?>
			</div>
			<div class="img-section" <?php echo (!empty($energy_logo_background)) ? 'style="background-image: url(' . esc_url($energy_logo_background) . ');"' : ''; ?>>
				<p class="fs-14 fw-500"><?php echo esc_html__('Also registered?', 'energy') ?></p>
				<h4><?php echo esc_html__('Log in', 'energy') ?></h4>
				<button class="button" data-toggle="modal-login"><?php echo esc_html__('Sign in', 'energy') ?></button>
			</div>
		</div>
	</div><!-- #search_dropdown -->
	<button id="login_modal_close" aria-controls="login_dropdown" class="nav-btn" aria-expanded="true" aria-label="<?php esc_attr_e('Login Toggler', 'energy'); ?>">
		<span></span>
	</button>
	<?php
	$energy_box_fade_in_class = energy_option('box_fade_in', '') ? 'box-fade-in' : 'box-normal';
	$energy_boxed = energy_option('boxed', '') ? 'boxed' : '';
	?>
	<div id="box" class="<?php echo esc_attr($energy_box_fade_in_class . ' ' . $energy_boxed); ?>">
		<?php

		//topline, header and title here:
		get_template_part('template-parts/header/header-top');

		//not opening container for 404 page or for full-width page template
		if (!is_page_template('page-templates/full-width.php') && !is_404() && !is_page_template('page-templates/home.php')) :
			$energy_main_sidebar_width   = energy_option('main_sidebar_width', '');
			$energy_main_gap_width       = energy_option('main_gap_width', 'default');
			$energy_extra_padding_top    = energy_option('main_extra_padding_top', '');
			$energy_extra_padding_bottom = energy_option('main_extra_padding_bottom', '');
			$energy_font_size            = energy_option('main_font_size', '');
			$energy_main_css_classes     = energy_get_page_main_section_css_classes();
			$energy_css_classes          = energy_get_layout_css_classes();

			if (empty($energy_extra_padding_top) && !energy_is_title_section_is_shown()) {
				$energy_extra_padding_top = 'pt-5';
			}
			//no top padding for page template without title and padding
			if (
				is_page_template('page-templates/no-sidebar-no-title.php')
				||
				is_page_template('page-templates/no-sidebar-no-padding.php')
				||
				is_page_template('page-templates/home.php')
			) {
				$energy_extra_padding_top    = 'pt-0';
				$energy_extra_padding_bottom = 'pb-0';
			}
		?>
			<div id="main" class="main <?php echo esc_attr('sidebar-' . $energy_main_sidebar_width . ' sidebar-gap-' . $energy_main_gap_width . ' ' . $energy_main_css_classes . ' ' . $energy_main_version); ?>">
				<div class="container <?php echo esc_attr($energy_extra_padding_top . ' ' . $energy_extra_padding_bottom); ?>">

					<?php
					/* Add breadcrumbs on cart, checkbox and order pages */
					if (class_exists('WooCommerce')) :
						if (is_cart() || is_checkout() || is_wc_endpoint_url('order-received')) :
					?>
							<ul class="breadcrumbs-woocommerce">
								<li>
									<a class="<?php echo esc_attr((is_cart()) ? 'active' : '') ?>" href="<?php echo esc_url(wc_get_cart_url()) ?>">
										<span><?php echo esc_html__('Shopping cart', 'energy') ?></span>
									</a>
								</li>
								<li>
									<a class="<?php echo esc_attr((is_checkout() && !is_wc_endpoint_url('order-received')) ? 'active' : '') ?>" href="<?php echo esc_url(wc_get_checkout_url()) ?>">
										<span><?php echo esc_html__('Checkout details', 'energy') ?></span>
									</a>
								</li>
								<li>
									<span <?php if (is_wc_endpoint_url('order-received')) echo ' class="active"'; ?>><?php echo esc_html__('Order complete', 'energy') ?></span>
								</li>
							</ul>
					<?php
						endif;
					endif;
					?>

					<?php
					//full width widget area before columns for home page
					if (energy_is_front_page() && is_active_sidebar('sidebar-home-before-columns')) :
					?>
						<div class="sidebar-home sidebar-home-before sidebar-home-before-columns">
							<?php dynamic_sidebar('sidebar-home-before-columns'); ?>
						</div><!-- .sidebar-home-before-columns -->
					<?php endif; ?>
					<div id="columns" class="main-columns">
						<main id="col" class="<?php echo esc_attr($energy_css_classes['main'] . ' ' . $energy_font_size); ?>">
						<?php
						/**
						 * Fires at the top of main column.
						 *
						 * @since WBPlank 0.0.1
						 */
						do_action('energy_action_top_of_main_column');

					endif; //full-width & 404
					if (energy_is_front_page() && is_active_sidebar('sidebar-home-before-content')) :
						?>
							<div class="sidebar-home sidebar-home-before sidebar-home-before-content">
								<?php dynamic_sidebar('sidebar-home-before-content'); ?>
							</div><!-- .sidebar-home-before-content -->
						<?php
					endif; //energy_is_front_page
