<?php

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//all Google fonts
if (!function_exists('energy_get_google_fonts_array')) :
	function energy_get_google_fonts_array()
	{
		return apply_filters(
			'energy_google_fonts_array',
			array(
				''                               => array(
					'family'   => '',
					'category' => '',
					'variants' => array(),
					'subsets'  => array(),
				),
				'ABeeZee'                        => array(
					'family'   => 'ABeeZee',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Abel'                           => array(
					'family'   => 'Abel',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Abhaya Libre'                   => array(
					'family'   => 'Abhaya Libre',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '600',
						3 => '700',
						4 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
						2 => 'sinhala',
					),
				),
				'Abril Fatface'                  => array(
					'family'   => 'Abril Fatface',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Aclonica'                       => array(
					'family'   => 'Aclonica',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Acme'                           => array(
					'family'   => 'Acme',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Actor'                          => array(
					'family'   => 'Actor',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Adamina'                        => array(
					'family'   => 'Adamina',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Advent Pro'                     => array(
					'family'   => 'Advent Pro',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
					),
					'subsets'  => array(
						0 => 'greek',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Aguafina Script'                => array(
					'family'   => 'Aguafina Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Akronim'                        => array(
					'family'   => 'Akronim',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Aladin'                         => array(
					'family'   => 'Aladin',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Aldrich'                        => array(
					'family'   => 'Aldrich',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Alef'                           => array(
					'family'   => 'Alef',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'hebrew',
						1 => 'latin',
					),
				),
				'Alegreya'                       => array(
					'family'   => 'Alegreya',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '700',
						5 => '700italic',
						6 => '800',
						7 => '800italic',
						8 => '900',
						9 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Alegreya SC'                    => array(
					'family'   => 'Alegreya SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '700',
						5 => '700italic',
						6 => '800',
						7 => '800italic',
						8 => '900',
						9 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Alegreya Sans'                  => array(
					'family'   => 'Alegreya Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '700',
						9  => '700italic',
						10 => '800',
						11 => '800italic',
						12 => '900',
						13 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Alegreya Sans SC'               => array(
					'family'   => 'Alegreya Sans SC',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '700',
						9  => '700italic',
						10 => '800',
						11 => '800italic',
						12 => '900',
						13 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Aleo'                           => array(
					'family'   => 'Aleo',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '700',
						5 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Alex Brush'                     => array(
					'family'   => 'Alex Brush',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Alfa Slab One'                  => array(
					'family'   => 'Alfa Slab One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Alice'                          => array(
					'family'   => 'Alice',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'cyrillic-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Alike'                          => array(
					'family'   => 'Alike',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Alike Angular'                  => array(
					'family'   => 'Alike Angular',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Allan'                          => array(
					'family'   => 'Allan',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Allerta'                        => array(
					'family'   => 'Allerta',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Allerta Stencil'                => array(
					'family'   => 'Allerta Stencil',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Allura'                         => array(
					'family'   => 'Allura',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Almendra'                       => array(
					'family'   => 'Almendra',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Almendra Display'               => array(
					'family'   => 'Almendra Display',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Almendra SC'                    => array(
					'family'   => 'Almendra SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Amarante'                       => array(
					'family'   => 'Amarante',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Amaranth'                       => array(
					'family'   => 'Amaranth',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Amatic SC'                      => array(
					'family'   => 'Amatic SC',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'hebrew',
						2 => 'latin-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Amethysta'                      => array(
					'family'   => 'Amethysta',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Amiko'                          => array(
					'family'   => 'Amiko',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '600',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Amiri'                          => array(
					'family'   => 'Amiri',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Amita'                          => array(
					'family'   => 'Amita',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Anaheim'                        => array(
					'family'   => 'Anaheim',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Andada'                         => array(
					'family'   => 'Andada',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Andika'                         => array(
					'family'   => 'Andika',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Angkor'                         => array(
					'family'   => 'Angkor',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Annie Use Your Telescope'       => array(
					'family'   => 'Annie Use Your Telescope',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Anonymous Pro'                  => array(
					'family'   => 'Anonymous Pro',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'greek',
						1 => 'latin-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Antic'                          => array(
					'family'   => 'Antic',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Antic Didone'                   => array(
					'family'   => 'Antic Didone',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Antic Slab'                     => array(
					'family'   => 'Antic Slab',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Anton'                          => array(
					'family'   => 'Anton',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Arapey'                         => array(
					'family'   => 'Arapey',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Arbutus'                        => array(
					'family'   => 'Arbutus',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Arbutus Slab'                   => array(
					'family'   => 'Arbutus Slab',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Architects Daughter'            => array(
					'family'   => 'Architects Daughter',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Archivo'                        => array(
					'family'   => 'Archivo',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '600',
						5 => '600italic',
						6 => '700',
						7 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Archivo Black'                  => array(
					'family'   => 'Archivo Black',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Archivo Narrow'                 => array(
					'family'   => 'Archivo Narrow',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '600',
						5 => '600italic',
						6 => '700',
						7 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Aref Ruqaa'                     => array(
					'family'   => 'Aref Ruqaa',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin',
					),
				),
				'Arima Madurai'                  => array(
					'family'   => 'Arima Madurai',
					'category' => 'display',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '700',
						6 => '800',
						7 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'tamil',
						3 => 'latin',
					),
				),
				'Arimo'                          => array(
					'family'   => 'Arimo',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'hebrew',
						3 => 'latin-ext',
						4 => 'greek-ext',
						5 => 'cyrillic-ext',
						6 => 'cyrillic',
						7 => 'latin',
					),
				),
				'Arizonia'                       => array(
					'family'   => 'Arizonia',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Armata'                         => array(
					'family'   => 'Armata',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Arsenal'                        => array(
					'family'   => 'Arsenal',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Artifika'                       => array(
					'family'   => 'Artifika',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Arvo'                           => array(
					'family'   => 'Arvo',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Arya'                           => array(
					'family'   => 'Arya',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Asap'                           => array(
					'family'   => 'Asap',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '600',
						5 => '600italic',
						6 => '700',
						7 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Asap Condensed'                 => array(
					'family'   => 'Asap Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '600',
						5 => '600italic',
						6 => '700',
						7 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Asar'                           => array(
					'family'   => 'Asar',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Asset'                          => array(
					'family'   => 'Asset',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Assistant'                      => array(
					'family'   => 'Assistant',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '600',
						4 => '700',
						5 => '800',
					),
					'subsets'  => array(
						0 => 'hebrew',
						1 => 'latin',
					),
				),
				'Astloch'                        => array(
					'family'   => 'Astloch',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Asul'                           => array(
					'family'   => 'Asul',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Athiti'                         => array(
					'family'   => 'Athiti',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Atma'                           => array(
					'family'   => 'Atma',
					'category' => 'display',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'bengali',
						2 => 'latin',
					),
				),
				'Atomic Age'                     => array(
					'family'   => 'Atomic Age',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Aubrey'                         => array(
					'family'   => 'Aubrey',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Audiowide'                      => array(
					'family'   => 'Audiowide',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Autour One'                     => array(
					'family'   => 'Autour One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Average'                        => array(
					'family'   => 'Average',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Average Sans'                   => array(
					'family'   => 'Average Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Averia Gruesa Libre'            => array(
					'family'   => 'Averia Gruesa Libre',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Averia Libre'                   => array(
					'family'   => 'Averia Libre',
					'category' => 'display',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '700',
						5 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Averia Sans Libre'              => array(
					'family'   => 'Averia Sans Libre',
					'category' => 'display',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '700',
						5 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Averia Serif Libre'             => array(
					'family'   => 'Averia Serif Libre',
					'category' => 'display',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '700',
						5 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'B612'                           => array(
					'family'   => 'B612',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'B612 Mono'                      => array(
					'family'   => 'B612 Mono',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Bad Script'                     => array(
					'family'   => 'Bad Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'cyrillic',
						1 => 'latin',
					),
				),
				'Bahiana'                        => array(
					'family'   => 'Bahiana',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Bai Jamjuree'                   => array(
					'family'   => 'Bai Jamjuree',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '600',
						9  => '600italic',
						10 => '700',
						11 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Baloo'                          => array(
					'family'   => 'Baloo',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'devanagari',
						3 => 'latin',
					),
				),
				'Baloo Bhai'                     => array(
					'family'   => 'Baloo Bhai',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'gujarati',
						3 => 'latin',
					),
				),
				'Baloo Bhaijaan'                 => array(
					'family'   => 'Baloo Bhaijaan',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'arabic',
						2 => 'latin-ext',
						3 => 'latin',
					),
				),
				'Baloo Bhaina'                   => array(
					'family'   => 'Baloo Bhaina',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'oriya',
						3 => 'latin',
					),
				),
				'Baloo Chettan'                  => array(
					'family'   => 'Baloo Chettan',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'malayalam',
						3 => 'latin',
					),
				),
				'Baloo Da'                       => array(
					'family'   => 'Baloo Da',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'bengali',
						3 => 'latin',
					),
				),
				'Baloo Paaji'                    => array(
					'family'   => 'Baloo Paaji',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'gurmukhi',
						3 => 'latin',
					),
				),
				'Baloo Tamma'                    => array(
					'family'   => 'Baloo Tamma',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'kannada',
						3 => 'latin',
					),
				),
				'Baloo Tammudu'                  => array(
					'family'   => 'Baloo Tammudu',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'telugu',
						3 => 'latin',
					),
				),
				'Baloo Thambi'                   => array(
					'family'   => 'Baloo Thambi',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'tamil',
						3 => 'latin',
					),
				),
				'Balthazar'                      => array(
					'family'   => 'Balthazar',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Bangers'                        => array(
					'family'   => 'Bangers',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Barlow'                         => array(
					'family'   => 'Barlow',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Barlow Condensed'               => array(
					'family'   => 'Barlow Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Barlow Semi Condensed'          => array(
					'family'   => 'Barlow Semi Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Barrio'                         => array(
					'family'   => 'Barrio',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Basic'                          => array(
					'family'   => 'Basic',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Battambang'                     => array(
					'family'   => 'Battambang',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Baumans'                        => array(
					'family'   => 'Baumans',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Bayon'                          => array(
					'family'   => 'Bayon',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Belgrano'                       => array(
					'family'   => 'Belgrano',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Bellefair'                      => array(
					'family'   => 'Bellefair',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'hebrew',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Belleza'                        => array(
					'family'   => 'Belleza',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'BenchNine'                      => array(
					'family'   => 'BenchNine',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Bentham'                        => array(
					'family'   => 'Bentham',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Berkshire Swash'                => array(
					'family'   => 'Berkshire Swash',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Bevan'                          => array(
					'family'   => 'Bevan',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Bigelow Rules'                  => array(
					'family'   => 'Bigelow Rules',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Bigshot One'                    => array(
					'family'   => 'Bigshot One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Bilbo'                          => array(
					'family'   => 'Bilbo',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Bilbo Swash Caps'               => array(
					'family'   => 'Bilbo Swash Caps',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'BioRhyme'                       => array(
					'family'   => 'BioRhyme',
					'category' => 'serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '700',
						4 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'BioRhyme Expanded'              => array(
					'family'   => 'BioRhyme Expanded',
					'category' => 'serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '700',
						4 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Biryani'                        => array(
					'family'   => 'Biryani',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '600',
						4 => '700',
						5 => '800',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Bitter'                         => array(
					'family'   => 'Bitter',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Black And White Picture'        => array(
					'family'   => 'Black And White Picture',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Black Han Sans'                 => array(
					'family'   => 'Black Han Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Black Ops One'                  => array(
					'family'   => 'Black Ops One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Bokor'                          => array(
					'family'   => 'Bokor',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Bonbon'                         => array(
					'family'   => 'Bonbon',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Boogaloo'                       => array(
					'family'   => 'Boogaloo',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Bowlby One'                     => array(
					'family'   => 'Bowlby One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Bowlby One SC'                  => array(
					'family'   => 'Bowlby One SC',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Brawler'                        => array(
					'family'   => 'Brawler',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Bree Serif'                     => array(
					'family'   => 'Bree Serif',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Bubblegum Sans'                 => array(
					'family'   => 'Bubblegum Sans',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Bubbler One'                    => array(
					'family'   => 'Bubbler One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Buda'                           => array(
					'family'   => 'Buda',
					'category' => 'display',
					'variants' => array(
						0 => '300',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Buenard'                        => array(
					'family'   => 'Buenard',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Bungee'                         => array(
					'family'   => 'Bungee',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Bungee Hairline'                => array(
					'family'   => 'Bungee Hairline',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Bungee Inline'                  => array(
					'family'   => 'Bungee Inline',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Bungee Outline'                 => array(
					'family'   => 'Bungee Outline',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Bungee Shade'                   => array(
					'family'   => 'Bungee Shade',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Butcherman'                     => array(
					'family'   => 'Butcherman',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Butterfly Kids'                 => array(
					'family'   => 'Butterfly Kids',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Cabin'                          => array(
					'family'   => 'Cabin',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '600',
						5 => '600italic',
						6 => '700',
						7 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Cabin Condensed'                => array(
					'family'   => 'Cabin Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '600',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Cabin Sketch'                   => array(
					'family'   => 'Cabin Sketch',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Caesar Dressing'                => array(
					'family'   => 'Caesar Dressing',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Cagliostro'                     => array(
					'family'   => 'Cagliostro',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Cairo'                          => array(
					'family'   => 'Cairo',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '600',
						4 => '700',
						5 => '900',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Calligraffitti'                 => array(
					'family'   => 'Calligraffitti',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Cambay'                         => array(
					'family'   => 'Cambay',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Cambo'                          => array(
					'family'   => 'Cambo',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Candal'                         => array(
					'family'   => 'Candal',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Cantarell'                      => array(
					'family'   => 'Cantarell',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Cantata One'                    => array(
					'family'   => 'Cantata One',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Cantora One'                    => array(
					'family'   => 'Cantora One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Capriola'                       => array(
					'family'   => 'Capriola',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Cardo'                          => array(
					'family'   => 'Cardo',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'greek',
						1 => 'latin-ext',
						2 => 'greek-ext',
						3 => 'latin',
					),
				),
				'Carme'                          => array(
					'family'   => 'Carme',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Carrois Gothic'                 => array(
					'family'   => 'Carrois Gothic',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Carrois Gothic SC'              => array(
					'family'   => 'Carrois Gothic SC',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Carter One'                     => array(
					'family'   => 'Carter One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Catamaran'                      => array(
					'family'   => 'Catamaran',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'tamil',
						2 => 'latin',
					),
				),
				'Caudex'                         => array(
					'family'   => 'Caudex',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'greek',
						1 => 'latin-ext',
						2 => 'greek-ext',
						3 => 'latin',
					),
				),
				'Caveat'                         => array(
					'family'   => 'Caveat',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Caveat Brush'                   => array(
					'family'   => 'Caveat Brush',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Cedarville Cursive'             => array(
					'family'   => 'Cedarville Cursive',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Ceviche One'                    => array(
					'family'   => 'Ceviche One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Chakra Petch'                   => array(
					'family'   => 'Chakra Petch',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '500',
						5 => '500italic',
						6 => '600',
						7 => '600italic',
						8 => '700',
						9 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Changa'                         => array(
					'family'   => 'Changa',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '800',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Changa One'                     => array(
					'family'   => 'Changa One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Chango'                         => array(
					'family'   => 'Chango',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Charm'                          => array(
					'family'   => 'Charm',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Charmonman'                     => array(
					'family'   => 'Charmonman',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Chathura'                       => array(
					'family'   => 'Chathura',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '300',
						2 => 'regular',
						3 => '700',
						4 => '800',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Chau Philomene One'             => array(
					'family'   => 'Chau Philomene One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Chela One'                      => array(
					'family'   => 'Chela One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Chelsea Market'                 => array(
					'family'   => 'Chelsea Market',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Chenla'                         => array(
					'family'   => 'Chenla',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Cherry Cream Soda'              => array(
					'family'   => 'Cherry Cream Soda',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Cherry Swash'                   => array(
					'family'   => 'Cherry Swash',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Chewy'                          => array(
					'family'   => 'Chewy',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Chicle'                         => array(
					'family'   => 'Chicle',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Chivo'                          => array(
					'family'   => 'Chivo',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '700',
						5 => '700italic',
						6 => '900',
						7 => '900italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Chonburi'                       => array(
					'family'   => 'Chonburi',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Cinzel'                         => array(
					'family'   => 'Cinzel',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
						2 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Cinzel Decorative'              => array(
					'family'   => 'Cinzel Decorative',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
						2 => '900',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Clicker Script'                 => array(
					'family'   => 'Clicker Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Coda'                           => array(
					'family'   => 'Coda',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Coda Caption'                   => array(
					'family'   => 'Coda Caption',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Codystar'                       => array(
					'family'   => 'Codystar',
					'category' => 'display',
					'variants' => array(
						0 => '300',
						1 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Coiny'                          => array(
					'family'   => 'Coiny',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'tamil',
						3 => 'latin',
					),
				),
				'Combo'                          => array(
					'family'   => 'Combo',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Comfortaa'                      => array(
					'family'   => 'Comfortaa',
					'category' => 'display',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'cyrillic-ext',
						4 => 'cyrillic',
						5 => 'latin',
					),
				),
				'Coming Soon'                    => array(
					'family'   => 'Coming Soon',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Concert One'                    => array(
					'family'   => 'Concert One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Condiment'                      => array(
					'family'   => 'Condiment',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Content'                        => array(
					'family'   => 'Content',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Contrail One'                   => array(
					'family'   => 'Contrail One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Convergence'                    => array(
					'family'   => 'Convergence',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Cookie'                         => array(
					'family'   => 'Cookie',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Copse'                          => array(
					'family'   => 'Copse',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Corben'                         => array(
					'family'   => 'Corben',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Cormorant'                      => array(
					'family'   => 'Cormorant',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '500',
						5 => '500italic',
						6 => '600',
						7 => '600italic',
						8 => '700',
						9 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Cormorant Garamond'             => array(
					'family'   => 'Cormorant Garamond',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '500',
						5 => '500italic',
						6 => '600',
						7 => '600italic',
						8 => '700',
						9 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Cormorant Infant'               => array(
					'family'   => 'Cormorant Infant',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '500',
						5 => '500italic',
						6 => '600',
						7 => '600italic',
						8 => '700',
						9 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Cormorant SC'                   => array(
					'family'   => 'Cormorant SC',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Cormorant Unicase'              => array(
					'family'   => 'Cormorant Unicase',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Cormorant Upright'              => array(
					'family'   => 'Cormorant Upright',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Courgette'                      => array(
					'family'   => 'Courgette',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Cousine'                        => array(
					'family'   => 'Cousine',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'hebrew',
						3 => 'latin-ext',
						4 => 'greek-ext',
						5 => 'cyrillic-ext',
						6 => 'cyrillic',
						7 => 'latin',
					),
				),
				'Coustard'                       => array(
					'family'   => 'Coustard',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '900',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Covered By Your Grace'          => array(
					'family'   => 'Covered By Your Grace',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Crafty Girls'                   => array(
					'family'   => 'Crafty Girls',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Creepster'                      => array(
					'family'   => 'Creepster',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Crete Round'                    => array(
					'family'   => 'Crete Round',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Crimson Text'                   => array(
					'family'   => 'Crimson Text',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '600',
						3 => '600italic',
						4 => '700',
						5 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Croissant One'                  => array(
					'family'   => 'Croissant One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Crushed'                        => array(
					'family'   => 'Crushed',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Cuprum'                         => array(
					'family'   => 'Cuprum',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Cute Font'                      => array(
					'family'   => 'Cute Font',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Cutive'                         => array(
					'family'   => 'Cutive',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Cutive Mono'                    => array(
					'family'   => 'Cutive Mono',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Damion'                         => array(
					'family'   => 'Damion',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Dancing Script'                 => array(
					'family'   => 'Dancing Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Dangrek'                        => array(
					'family'   => 'Dangrek',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'David Libre'                    => array(
					'family'   => 'David Libre',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'hebrew',
						2 => 'latin-ext',
						3 => 'latin',
					),
				),
				'Dawning of a New Day'           => array(
					'family'   => 'Dawning of a New Day',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Days One'                       => array(
					'family'   => 'Days One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Dekko'                          => array(
					'family'   => 'Dekko',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Delius'                         => array(
					'family'   => 'Delius',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Delius Swash Caps'              => array(
					'family'   => 'Delius Swash Caps',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Delius Unicase'                 => array(
					'family'   => 'Delius Unicase',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Della Respira'                  => array(
					'family'   => 'Della Respira',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Denk One'                       => array(
					'family'   => 'Denk One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Devonshire'                     => array(
					'family'   => 'Devonshire',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Dhurjati'                       => array(
					'family'   => 'Dhurjati',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Didact Gothic'                  => array(
					'family'   => 'Didact Gothic',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'greek',
						1 => 'latin-ext',
						2 => 'greek-ext',
						3 => 'cyrillic-ext',
						4 => 'cyrillic',
						5 => 'latin',
					),
				),
				'Diplomata'                      => array(
					'family'   => 'Diplomata',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Diplomata SC'                   => array(
					'family'   => 'Diplomata SC',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'DM Sans'                       => array(
					'family'   => 'DM Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0  => 'regular',
						1  => 'italic',
						2  => '500',
						3  => '500italic',
						4  => '700',
						5  => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Do Hyeon'                       => array(
					'family'   => 'Do Hyeon',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Dokdo'                          => array(
					'family'   => 'Dokdo',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Domine'                         => array(
					'family'   => 'Domine',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Donegal One'                    => array(
					'family'   => 'Donegal One',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Doppio One'                     => array(
					'family'   => 'Doppio One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Dorsa'                          => array(
					'family'   => 'Dorsa',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Dosis'                          => array(
					'family'   => 'Dosis',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Dr Sugiyama'                    => array(
					'family'   => 'Dr Sugiyama',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Duru Sans'                      => array(
					'family'   => 'Duru Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Dynalight'                      => array(
					'family'   => 'Dynalight',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'EB Garamond'                    => array(
					'family'   => 'EB Garamond',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '600',
						5 => '600italic',
						6 => '700',
						7 => '700italic',
						8 => '800',
						9 => '800italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Eagle Lake'                     => array(
					'family'   => 'Eagle Lake',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'East Sea Dokdo'                 => array(
					'family'   => 'East Sea Dokdo',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Eater'                          => array(
					'family'   => 'Eater',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Economica'                      => array(
					'family'   => 'Economica',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Eczar'                          => array(
					'family'   => 'Eczar',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '600',
						3 => '700',
						4 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'El Messiri'                     => array(
					'family'   => 'El Messiri',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '600',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Electrolize'                    => array(
					'family'   => 'Electrolize',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Elsie'                          => array(
					'family'   => 'Elsie',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Elsie Swash Caps'               => array(
					'family'   => 'Elsie Swash Caps',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Emblema One'                    => array(
					'family'   => 'Emblema One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Emilys Candy'                   => array(
					'family'   => 'Emilys Candy',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Encode Sans'                    => array(
					'family'   => 'Encode Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Encode Sans Condensed'          => array(
					'family'   => 'Encode Sans Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Encode Sans Expanded'           => array(
					'family'   => 'Encode Sans Expanded',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Encode Sans Semi Condensed'     => array(
					'family'   => 'Encode Sans Semi Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Encode Sans Semi Expanded'      => array(
					'family'   => 'Encode Sans Semi Expanded',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Engagement'                     => array(
					'family'   => 'Engagement',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Englebert'                      => array(
					'family'   => 'Englebert',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Enriqueta'                      => array(
					'family'   => 'Enriqueta',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Erica One'                      => array(
					'family'   => 'Erica One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Esteban'                        => array(
					'family'   => 'Esteban',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Euphoria Script'                => array(
					'family'   => 'Euphoria Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Ewert'                          => array(
					'family'   => 'Ewert',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Exo'                            => array(
					'family'   => 'Exo',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Exo 2'                          => array(
					'family'   => 'Exo 2',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Expletus Sans'                  => array(
					'family'   => 'Expletus Sans',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '600',
						5 => '600italic',
						6 => '700',
						7 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Fahkwang'                       => array(
					'family'   => 'Fahkwang',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '600',
						9  => '600italic',
						10 => '700',
						11 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Fanwood Text'                   => array(
					'family'   => 'Fanwood Text',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Farsan'                         => array(
					'family'   => 'Farsan',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'gujarati',
						3 => 'latin',
					),
				),
				'Fascinate'                      => array(
					'family'   => 'Fascinate',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Fascinate Inline'               => array(
					'family'   => 'Fascinate Inline',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Faster One'                     => array(
					'family'   => 'Faster One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Fasthand'                       => array(
					'family'   => 'Fasthand',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Fauna One'                      => array(
					'family'   => 'Fauna One',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Faustina'                       => array(
					'family'   => 'Faustina',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '600',
						5 => '600italic',
						6 => '700',
						7 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Federant'                       => array(
					'family'   => 'Federant',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Federo'                         => array(
					'family'   => 'Federo',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Felipa'                         => array(
					'family'   => 'Felipa',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Fenix'                          => array(
					'family'   => 'Fenix',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Finger Paint'                   => array(
					'family'   => 'Finger Paint',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Fira Mono'                      => array(
					'family'   => 'Fira Mono',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'greek',
						1 => 'latin-ext',
						2 => 'greek-ext',
						3 => 'cyrillic-ext',
						4 => 'cyrillic',
						5 => 'latin',
					),
				),
				'Fira Sans'                      => array(
					'family'   => 'Fira Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Fira Sans Condensed'            => array(
					'family'   => 'Fira Sans Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Fira Sans Extra Condensed'      => array(
					'family'   => 'Fira Sans Extra Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Fjalla One'                     => array(
					'family'   => 'Fjalla One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Fjord One'                      => array(
					'family'   => 'Fjord One',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Flamenco'                       => array(
					'family'   => 'Flamenco',
					'category' => 'display',
					'variants' => array(
						0 => '300',
						1 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Flavors'                        => array(
					'family'   => 'Flavors',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Fondamento'                     => array(
					'family'   => 'Fondamento',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Fontdiner Swanky'               => array(
					'family'   => 'Fontdiner Swanky',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Forum'                          => array(
					'family'   => 'Forum',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Francois One'                   => array(
					'family'   => 'Francois One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Frank Ruhl Libre'               => array(
					'family'   => 'Frank Ruhl Libre',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '700',
						4 => '900',
					),
					'subsets'  => array(
						0 => 'hebrew',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Freckle Face'                   => array(
					'family'   => 'Freckle Face',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Fredericka the Great'           => array(
					'family'   => 'Fredericka the Great',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Fredoka One'                    => array(
					'family'   => 'Fredoka One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Freehand'                       => array(
					'family'   => 'Freehand',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Fresca'                         => array(
					'family'   => 'Fresca',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Frijole'                        => array(
					'family'   => 'Frijole',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Fruktur'                        => array(
					'family'   => 'Fruktur',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Fugaz One'                      => array(
					'family'   => 'Fugaz One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'GFS Didot'                      => array(
					'family'   => 'GFS Didot',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'greek',
					),
				),
				'GFS Neohellenic'                => array(
					'family'   => 'GFS Neohellenic',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'greek',
					),
				),
				'Gabriela'                       => array(
					'family'   => 'Gabriela',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'cyrillic-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Gaegu'                          => array(
					'family'   => 'Gaegu',
					'category' => 'handwriting',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Gafata'                         => array(
					'family'   => 'Gafata',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Galada'                         => array(
					'family'   => 'Galada',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'bengali',
						1 => 'latin',
					),
				),
				'Galdeano'                       => array(
					'family'   => 'Galdeano',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Galindo'                        => array(
					'family'   => 'Galindo',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Gamja Flower'                   => array(
					'family'   => 'Gamja Flower',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Gentium Basic'                  => array(
					'family'   => 'Gentium Basic',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Gentium Book Basic'             => array(
					'family'   => 'Gentium Book Basic',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Geo'                            => array(
					'family'   => 'Geo',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Geostar'                        => array(
					'family'   => 'Geostar',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Geostar Fill'                   => array(
					'family'   => 'Geostar Fill',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Germania One'                   => array(
					'family'   => 'Germania One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Gidugu'                         => array(
					'family'   => 'Gidugu',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Gilda Display'                  => array(
					'family'   => 'Gilda Display',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Give You Glory'                 => array(
					'family'   => 'Give You Glory',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Glass Antiqua'                  => array(
					'family'   => 'Glass Antiqua',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Glegoo'                         => array(
					'family'   => 'Glegoo',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Gloria Hallelujah'              => array(
					'family'   => 'Gloria Hallelujah',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Goblin One'                     => array(
					'family'   => 'Goblin One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Gochi Hand'                     => array(
					'family'   => 'Gochi Hand',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Gorditas'                       => array(
					'family'   => 'Gorditas',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Gothic A1'                      => array(
					'family'   => 'Gothic A1',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Goudy Bookletter 1911'          => array(
					'family'   => 'Goudy Bookletter 1911',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Graduate'                       => array(
					'family'   => 'Graduate',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Grand Hotel'                    => array(
					'family'   => 'Grand Hotel',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Gravitas One'                   => array(
					'family'   => 'Gravitas One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Great Vibes'                    => array(
					'family'   => 'Great Vibes',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Griffy'                         => array(
					'family'   => 'Griffy',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Gruppo'                         => array(
					'family'   => 'Gruppo',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Gudea'                          => array(
					'family'   => 'Gudea',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Gugi'                           => array(
					'family'   => 'Gugi',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Gurajada'                       => array(
					'family'   => 'Gurajada',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Habibi'                         => array(
					'family'   => 'Habibi',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Halant'                         => array(
					'family'   => 'Halant',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Hammersmith One'                => array(
					'family'   => 'Hammersmith One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Hanalei'                        => array(
					'family'   => 'Hanalei',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Hanalei Fill'                   => array(
					'family'   => 'Hanalei Fill',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Handlee'                        => array(
					'family'   => 'Handlee',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Hanuman'                        => array(
					'family'   => 'Hanuman',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Happy Monkey'                   => array(
					'family'   => 'Happy Monkey',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Harmattan'                      => array(
					'family'   => 'Harmattan',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin',
					),
				),
				'Headland One'                   => array(
					'family'   => 'Headland One',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Heebo'                          => array(
					'family'   => 'Heebo',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '700',
						5 => '800',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'hebrew',
						1 => 'latin',
					),
				),
				'Henny Penny'                    => array(
					'family'   => 'Henny Penny',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Herr Von Muellerhoff'           => array(
					'family'   => 'Herr Von Muellerhoff',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Hi Melody'                      => array(
					'family'   => 'Hi Melody',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Hind'                           => array(
					'family'   => 'Hind',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Hind Guntur'                    => array(
					'family'   => 'Hind Guntur',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'telugu',
						2 => 'latin',
					),
				),
				'Hind Madurai'                   => array(
					'family'   => 'Hind Madurai',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'tamil',
						2 => 'latin',
					),
				),
				'Hind Siliguri'                  => array(
					'family'   => 'Hind Siliguri',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'bengali',
						2 => 'latin',
					),
				),
				'Hind Vadodara'                  => array(
					'family'   => 'Hind Vadodara',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'gujarati',
						2 => 'latin',
					),
				),
				'Holtwood One SC'                => array(
					'family'   => 'Holtwood One SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Homemade Apple'                 => array(
					'family'   => 'Homemade Apple',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Homenaje'                       => array(
					'family'   => 'Homenaje',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'IBM Plex Mono'                  => array(
					'family'   => 'IBM Plex Mono',
					'category' => 'monospace',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'IBM Plex Sans'                  => array(
					'family'   => 'IBM Plex Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'IBM Plex Sans Condensed'        => array(
					'family'   => 'IBM Plex Sans Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'IBM Plex Serif'                 => array(
					'family'   => 'IBM Plex Serif',
					'category' => 'serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'IM Fell DW Pica'                => array(
					'family'   => 'IM Fell DW Pica',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'IM Fell DW Pica SC'             => array(
					'family'   => 'IM Fell DW Pica SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'IM Fell Double Pica'            => array(
					'family'   => 'IM Fell Double Pica',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'IM Fell Double Pica SC'         => array(
					'family'   => 'IM Fell Double Pica SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'IM Fell English'                => array(
					'family'   => 'IM Fell English',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'IM Fell English SC'             => array(
					'family'   => 'IM Fell English SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'IM Fell French Canon'           => array(
					'family'   => 'IM Fell French Canon',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'IM Fell French Canon SC'        => array(
					'family'   => 'IM Fell French Canon SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'IM Fell Great Primer'           => array(
					'family'   => 'IM Fell Great Primer',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'IM Fell Great Primer SC'        => array(
					'family'   => 'IM Fell Great Primer SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Iceberg'                        => array(
					'family'   => 'Iceberg',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Iceland'                        => array(
					'family'   => 'Iceland',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Imprima'                        => array(
					'family'   => 'Imprima',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Inconsolata'                    => array(
					'family'   => 'Inconsolata',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Inder'                          => array(
					'family'   => 'Inder',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Indie Flower'                   => array(
					'family'   => 'Indie Flower',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Inika'                          => array(
					'family'   => 'Inika',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Inknut Antiqua'                 => array(
					'family'   => 'Inknut Antiqua',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
						5 => '800',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Inter'                 => array(
					'family'   => 'Inter',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'cyrillic-ext',
						1 => 'cyrillic',
						2 => 'greek-ext',
						3 => 'greek',
						4 => 'vietnamese',
						5 => 'latin-ext',
						6 => 'latin',
					),
				),
				'Irish Grover'                   => array(
					'family'   => 'Irish Grover',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Istok Web'                      => array(
					'family'   => 'Istok Web',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Italiana'                       => array(
					'family'   => 'Italiana',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Italianno'                      => array(
					'family'   => 'Italianno',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Itim'                           => array(
					'family'   => 'Itim',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Jacques Francois'               => array(
					'family'   => 'Jacques Francois',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Jacques Francois Shadow'        => array(
					'family'   => 'Jacques Francois Shadow',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Jaldi'                          => array(
					'family'   => 'Jaldi',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Jim Nightshade'                 => array(
					'family'   => 'Jim Nightshade',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Jockey One'                     => array(
					'family'   => 'Jockey One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Jolly Lodger'                   => array(
					'family'   => 'Jolly Lodger',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Jomhuria'                       => array(
					'family'   => 'Jomhuria',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Josefin Sans'                   => array(
					'family'   => 'Josefin Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '100italic',
						2 => '300',
						3 => '300italic',
						4 => 'regular',
						5 => 'italic',
						6 => '600',
						7 => '600italic',
						8 => '700',
						9 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Josefin Slab'                   => array(
					'family'   => 'Josefin Slab',
					'category' => 'serif',
					'variants' => array(
						0 => '100',
						1 => '100italic',
						2 => '300',
						3 => '300italic',
						4 => 'regular',
						5 => 'italic',
						6 => '600',
						7 => '600italic',
						8 => '700',
						9 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Jost'                         => array(
					'family'   => 'Jost',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '600',
						9  => '600italic',
						10 => '700',
						11 => '700italic',
						12 => '800',
						13 => '800italic',
						14 => '900',
						15 => '900italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
					),
				),
				'Joti One'                       => array(
					'family'   => 'Joti One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Jua'                            => array(
					'family'   => 'Jua',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Judson'                         => array(
					'family'   => 'Judson',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Julee'                          => array(
					'family'   => 'Julee',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Julius Sans One'                => array(
					'family'   => 'Julius Sans One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Junge'                          => array(
					'family'   => 'Junge',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Jura'                           => array(
					'family'   => 'Jura',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Just Another Hand'              => array(
					'family'   => 'Just Another Hand',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Just Me Again Down Here'        => array(
					'family'   => 'Just Me Again Down Here',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'K2D'                            => array(
					'family'   => 'K2D',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Kadwa'                          => array(
					'family'   => 'Kadwa',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'devanagari',
						1 => 'latin',
					),
				),
				'Kalam'                          => array(
					'family'   => 'Kalam',
					'category' => 'handwriting',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Kameron'                        => array(
					'family'   => 'Kameron',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Kanit'                          => array(
					'family'   => 'Kanit',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Kantumruy'                      => array(
					'family'   => 'Kantumruy',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Karla'                          => array(
					'family'   => 'Karla',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Karma'                          => array(
					'family'   => 'Karma',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Katibeh'                        => array(
					'family'   => 'Katibeh',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Kaushan Script'                 => array(
					'family'   => 'Kaushan Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Kavivanar'                      => array(
					'family'   => 'Kavivanar',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'tamil',
						2 => 'latin',
					),
				),
				'Kavoon'                         => array(
					'family'   => 'Kavoon',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Kdam Thmor'                     => array(
					'family'   => 'Kdam Thmor',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Keania One'                     => array(
					'family'   => 'Keania One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Kelly Slab'                     => array(
					'family'   => 'Kelly Slab',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Kenia'                          => array(
					'family'   => 'Kenia',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Khand'                          => array(
					'family'   => 'Khand',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Khmer'                          => array(
					'family'   => 'Khmer',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Khula'                          => array(
					'family'   => 'Khula',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '600',
						3 => '700',
						4 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Kirang Haerang'                 => array(
					'family'   => 'Kirang Haerang',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Kite One'                       => array(
					'family'   => 'Kite One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Knewave'                        => array(
					'family'   => 'Knewave',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'KoHo'                           => array(
					'family'   => 'KoHo',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '600',
						9  => '600italic',
						10 => '700',
						11 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Kodchasan'                      => array(
					'family'   => 'Kodchasan',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '600',
						9  => '600italic',
						10 => '700',
						11 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Kosugi'                         => array(
					'family'   => 'Kosugi',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Kosugi Maru'                    => array(
					'family'   => 'Kosugi Maru',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Kotta One'                      => array(
					'family'   => 'Kotta One',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Koulen'                         => array(
					'family'   => 'Koulen',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Kranky'                         => array(
					'family'   => 'Kranky',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Kreon'                          => array(
					'family'   => 'Kreon',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Kristi'                         => array(
					'family'   => 'Kristi',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Krona One'                      => array(
					'family'   => 'Krona One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Krub'                           => array(
					'family'   => 'Krub',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '600',
						9  => '600italic',
						10 => '700',
						11 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Kumar One'                      => array(
					'family'   => 'Kumar One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'gujarati',
						2 => 'latin',
					),
				),
				'Kumar One Outline'              => array(
					'family'   => 'Kumar One Outline',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'gujarati',
						2 => 'latin',
					),
				),
				'Kurale'                         => array(
					'family'   => 'Kurale',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'devanagari',
						4 => 'latin',
					),
				),
				'La Belle Aurore'                => array(
					'family'   => 'La Belle Aurore',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Laila'                          => array(
					'family'   => 'Laila',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Lakki Reddy'                    => array(
					'family'   => 'Lakki Reddy',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Lalezar'                        => array(
					'family'   => 'Lalezar',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'arabic',
						2 => 'latin-ext',
						3 => 'latin',
					),
				),
				'Lancelot'                       => array(
					'family'   => 'Lancelot',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Lateef'                         => array(
					'family'   => 'Lateef',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin',
					),
				),
				'Lato'                           => array(
					'family'   => 'Lato',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '100italic',
						2 => '300',
						3 => '300italic',
						4 => 'regular',
						5 => 'italic',
						6 => '700',
						7 => '700italic',
						8 => '900',
						9 => '900italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'League Script'                  => array(
					'family'   => 'League Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Leckerli One'                   => array(
					'family'   => 'Leckerli One',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Ledger'                         => array(
					'family'   => 'Ledger',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Lekton'                         => array(
					'family'   => 'Lekton',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Lemon'                          => array(
					'family'   => 'Lemon',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Lemonada'                       => array(
					'family'   => 'Lemonada',
					'category' => 'display',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '600',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'arabic',
						2 => 'latin-ext',
						3 => 'latin',
					),
				),
				'Libre Barcode 128'              => array(
					'family'   => 'Libre Barcode 128',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Libre Barcode 128 Text'         => array(
					'family'   => 'Libre Barcode 128 Text',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Libre Barcode 39'               => array(
					'family'   => 'Libre Barcode 39',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Libre Barcode 39 Extended'      => array(
					'family'   => 'Libre Barcode 39 Extended',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Libre Barcode 39 Extended Text' => array(
					'family'   => 'Libre Barcode 39 Extended Text',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Libre Barcode 39 Text'          => array(
					'family'   => 'Libre Barcode 39 Text',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Libre Baskerville'              => array(
					'family'   => 'Libre Baskerville',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Libre Franklin'                 => array(
					'family'   => 'Libre Franklin',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Life Savers'                    => array(
					'family'   => 'Life Savers',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Lilita One'                     => array(
					'family'   => 'Lilita One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Lily Script One'                => array(
					'family'   => 'Lily Script One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Limelight'                      => array(
					'family'   => 'Limelight',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Linden Hill'                    => array(
					'family'   => 'Linden Hill',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Lobster'                        => array(
					'family'   => 'Lobster',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Lobster Two'                    => array(
					'family'   => 'Lobster Two',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Londrina Outline'               => array(
					'family'   => 'Londrina Outline',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Londrina Shadow'                => array(
					'family'   => 'Londrina Shadow',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Londrina Sketch'                => array(
					'family'   => 'Londrina Sketch',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Londrina Solid'                 => array(
					'family'   => 'Londrina Solid',
					'category' => 'display',
					'variants' => array(
						0 => '100',
						1 => '300',
						2 => 'regular',
						3 => '900',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Lora'                           => array(
					'family'   => 'Lora',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Love Ya Like A Sister'          => array(
					'family'   => 'Love Ya Like A Sister',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Loved by the King'              => array(
					'family'   => 'Loved by the King',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Lovers Quarrel'                 => array(
					'family'   => 'Lovers Quarrel',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Luckiest Guy'                   => array(
					'family'   => 'Luckiest Guy',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Lusitana'                       => array(
					'family'   => 'Lusitana',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Lustria'                        => array(
					'family'   => 'Lustria',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'M PLUS 1p'                      => array(
					'family'   => 'M PLUS 1p',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '700',
						5 => '800',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'vietnamese',
						2 => 'greek',
						3 => 'hebrew',
						4 => 'latin-ext',
						5 => 'greek-ext',
						6 => 'cyrillic-ext',
						7 => 'cyrillic',
						8 => 'latin',
					),
				),
				'M PLUS Rounded 1c'              => array(
					'family'   => 'M PLUS Rounded 1c',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '700',
						5 => '800',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'vietnamese',
						2 => 'greek',
						3 => 'hebrew',
						4 => 'latin-ext',
						5 => 'greek-ext',
						6 => 'cyrillic-ext',
						7 => 'cyrillic',
						8 => 'latin',
					),
				),
				'Macondo'                        => array(
					'family'   => 'Macondo',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Macondo Swash Caps'             => array(
					'family'   => 'Macondo Swash Caps',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Mada'                           => array(
					'family'   => 'Mada',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin',
					),
				),
				'Magra'                          => array(
					'family'   => 'Magra',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Maiden Orange'                  => array(
					'family'   => 'Maiden Orange',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Maitree'                        => array(
					'family'   => 'Maitree',
					'category' => 'serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Major Mono Display'             => array(
					'family'   => 'Major Mono Display',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Mako'                           => array(
					'family'   => 'Mako',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Mali'                           => array(
					'family'   => 'Mali',
					'category' => 'handwriting',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '600',
						9  => '600italic',
						10 => '700',
						11 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Mallanna'                       => array(
					'family'   => 'Mallanna',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Mandali'                        => array(
					'family'   => 'Mandali',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Manuale'                        => array(
					'family'   => 'Manuale',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '600',
						5 => '600italic',
						6 => '700',
						7 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Marcellus'                      => array(
					'family'   => 'Marcellus',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Marcellus SC'                   => array(
					'family'   => 'Marcellus SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Marck Script'                   => array(
					'family'   => 'Marck Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Margarine'                      => array(
					'family'   => 'Margarine',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Markazi Text'                   => array(
					'family'   => 'Markazi Text',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '600',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'arabic',
						2 => 'latin-ext',
						3 => 'latin',
					),
				),
				'Marko One'                      => array(
					'family'   => 'Marko One',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Marmelad'                       => array(
					'family'   => 'Marmelad',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Martel'                         => array(
					'family'   => 'Martel',
					'category' => 'serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '600',
						4 => '700',
						5 => '800',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Martel Sans'                    => array(
					'family'   => 'Martel Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '600',
						4 => '700',
						5 => '800',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Marvel'                         => array(
					'family'   => 'Marvel',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Mate'                           => array(
					'family'   => 'Mate',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Mate SC'                        => array(
					'family'   => 'Mate SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Maven Pro'                      => array(
					'family'   => 'Maven Pro',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '700',
						3 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'McLaren'                        => array(
					'family'   => 'McLaren',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Meddon'                         => array(
					'family'   => 'Meddon',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'MedievalSharp'                  => array(
					'family'   => 'MedievalSharp',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Medula One'                     => array(
					'family'   => 'Medula One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Meera Inimai'                   => array(
					'family'   => 'Meera Inimai',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'tamil',
						1 => 'latin',
					),
				),
				'Megrim'                         => array(
					'family'   => 'Megrim',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Meie Script'                    => array(
					'family'   => 'Meie Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Merienda'                       => array(
					'family'   => 'Merienda',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Merienda One'                   => array(
					'family'   => 'Merienda One',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Merriweather'                   => array(
					'family'   => 'Merriweather',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '700',
						5 => '700italic',
						6 => '900',
						7 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Merriweather Sans'              => array(
					'family'   => 'Merriweather Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '700',
						5 => '700italic',
						6 => '800',
						7 => '800italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Metal'                          => array(
					'family'   => 'Metal',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Metal Mania'                    => array(
					'family'   => 'Metal Mania',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Metamorphous'                   => array(
					'family'   => 'Metamorphous',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Metrophobic'                    => array(
					'family'   => 'Metrophobic',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Michroma'                       => array(
					'family'   => 'Michroma',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Milonga'                        => array(
					'family'   => 'Milonga',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Miltonian'                      => array(
					'family'   => 'Miltonian',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Miltonian Tattoo'               => array(
					'family'   => 'Miltonian Tattoo',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Mina'                           => array(
					'family'   => 'Mina',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'bengali',
						2 => 'latin',
					),
				),
				'Miniver'                        => array(
					'family'   => 'Miniver',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Miriam Libre'                   => array(
					'family'   => 'Miriam Libre',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'hebrew',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Mirza'                          => array(
					'family'   => 'Mirza',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '600',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Miss Fajardose'                 => array(
					'family'   => 'Miss Fajardose',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Mitr'                           => array(
					'family'   => 'Mitr',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Modak'                          => array(
					'family'   => 'Modak',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Modern Antiqua'                 => array(
					'family'   => 'Modern Antiqua',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Mogra'                          => array(
					'family'   => 'Mogra',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'gujarati',
						2 => 'latin',
					),
				),
				'Molengo'                        => array(
					'family'   => 'Molengo',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Molle'                          => array(
					'family'   => 'Molle',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Monda'                          => array(
					'family'   => 'Monda',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Monofett'                       => array(
					'family'   => 'Monofett',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Monoton'                        => array(
					'family'   => 'Monoton',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Monsieur La Doulaise'           => array(
					'family'   => 'Monsieur La Doulaise',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Montaga'                        => array(
					'family'   => 'Montaga',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Montez'                         => array(
					'family'   => 'Montez',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Montserrat'                     => array(
					'family'   => 'Montserrat',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Montserrat Alternates'          => array(
					'family'   => 'Montserrat Alternates',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Montserrat Subrayada'           => array(
					'family'   => 'Montserrat Subrayada',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Moul'                           => array(
					'family'   => 'Moul',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Moulpali'                       => array(
					'family'   => 'Moulpali',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Mountains of Christmas'         => array(
					'family'   => 'Mountains of Christmas',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Mouse Memoirs'                  => array(
					'family'   => 'Mouse Memoirs',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Mr Bedfort'                     => array(
					'family'   => 'Mr Bedfort',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Mr Dafoe'                       => array(
					'family'   => 'Mr Dafoe',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Mr De Haviland'                 => array(
					'family'   => 'Mr De Haviland',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Mrs Saint Delafield'            => array(
					'family'   => 'Mrs Saint Delafield',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Mrs Sheppards'                  => array(
					'family'   => 'Mrs Sheppards',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Mukta'                          => array(
					'family'   => 'Mukta',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Mukta Mahee'                    => array(
					'family'   => 'Mukta Mahee',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'gurmukhi',
						2 => 'latin',
					),
				),
				'Mukta Malar'                    => array(
					'family'   => 'Mukta Malar',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'tamil',
						2 => 'latin',
					),
				),
				'Mukta Vaani'                    => array(
					'family'   => 'Mukta Vaani',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'gujarati',
						2 => 'latin',
					),
				),
				'Muli'                           => array(
					'family'   => 'Muli',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '600',
						7  => '600italic',
						8  => '700',
						9  => '700italic',
						10 => '800',
						11 => '800italic',
						12 => '900',
						13 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Mystery Quest'                  => array(
					'family'   => 'Mystery Quest',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'NTR'                            => array(
					'family'   => 'NTR',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Nanum Brush Script'             => array(
					'family'   => 'Nanum Brush Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Nanum Gothic'                   => array(
					'family'   => 'Nanum Gothic',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
						2 => '800',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Nanum Gothic Coding'            => array(
					'family'   => 'Nanum Gothic Coding',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Nanum Myeongjo'                 => array(
					'family'   => 'Nanum Myeongjo',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
						2 => '800',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Nanum Pen Script'               => array(
					'family'   => 'Nanum Pen Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Neucha'                         => array(
					'family'   => 'Neucha',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'cyrillic',
						1 => 'latin',
					),
				),
				'Neuton'                         => array(
					'family'   => 'Neuton',
					'category' => 'serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => 'italic',
						4 => '700',
						5 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'New Rocker'                     => array(
					'family'   => 'New Rocker',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'News Cycle'                     => array(
					'family'   => 'News Cycle',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Niconne'                        => array(
					'family'   => 'Niconne',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Niramit'                        => array(
					'family'   => 'Niramit',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '600',
						9  => '600italic',
						10 => '700',
						11 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Nixie One'                      => array(
					'family'   => 'Nixie One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Nobile'                         => array(
					'family'   => 'Nobile',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '700',
						5 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Nokora'                         => array(
					'family'   => 'Nokora',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Norican'                        => array(
					'family'   => 'Norican',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Nosifer'                        => array(
					'family'   => 'Nosifer',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Notable'                        => array(
					'family'   => 'Notable',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Nothing You Could Do'           => array(
					'family'   => 'Nothing You Could Do',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Noticia Text'                   => array(
					'family'   => 'Noticia Text',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Noto Sans'                      => array(
					'family'   => 'Noto Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'devanagari',
						7 => 'latin',
					),
				),
				'Noto Sans JP'                   => array(
					'family'   => 'Noto Sans JP',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '700',
						5 => '900',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'latin',
					),
				),
				'Noto Sans KR'                   => array(
					'family'   => 'Noto Sans KR',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '700',
						5 => '900',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Noto Sans SC'                   => array(
					'family'   => 'Noto Sans SC',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '700',
						5 => '900',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'vietnamese',
						2 => 'cyrillic',
						3 => 'chinese-simplified',
						4 => 'latin',
					),
				),
				'Noto Sans TC'                   => array(
					'family'   => 'Noto Sans TC',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '700',
						5 => '900',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'chinese-traditional',
						2 => 'latin',
					),
				),
				'Noto Serif'                     => array(
					'family'   => 'Noto Serif',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Noto Serif JP'                  => array(
					'family'   => 'Noto Serif JP',
					'category' => 'serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'latin',
					),
				),
				'Noto Serif KR'                  => array(
					'family'   => 'Noto Serif KR',
					'category' => 'serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Noto Serif SC'                  => array(
					'family'   => 'Noto Serif SC',
					'category' => 'serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'vietnamese',
						2 => 'cyrillic',
						3 => 'chinese-simplified',
						4 => 'latin',
					),
				),
				'Noto Serif TC'                  => array(
					'family'   => 'Noto Serif TC',
					'category' => 'serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'vietnamese',
						2 => 'cyrillic',
						3 => 'chinese-traditional',
						4 => 'latin',
					),
				),
				'Nova Cut'                       => array(
					'family'   => 'Nova Cut',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Nova Flat'                      => array(
					'family'   => 'Nova Flat',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Nova Mono'                      => array(
					'family'   => 'Nova Mono',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'greek',
						1 => 'latin',
					),
				),
				'Nova Oval'                      => array(
					'family'   => 'Nova Oval',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Nova Round'                     => array(
					'family'   => 'Nova Round',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Nova Script'                    => array(
					'family'   => 'Nova Script',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Nova Slim'                      => array(
					'family'   => 'Nova Slim',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Nova Square'                    => array(
					'family'   => 'Nova Square',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Numans'                         => array(
					'family'   => 'Numans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Nunito'                         => array(
					'family'   => 'Nunito',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '600',
						7  => '600italic',
						8  => '700',
						9  => '700italic',
						10 => '800',
						11 => '800italic',
						12 => '900',
						13 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Nunito Sans'                    => array(
					'family'   => 'Nunito Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '600',
						7  => '600italic',
						8  => '700',
						9  => '700italic',
						10 => '800',
						11 => '800italic',
						12 => '900',
						13 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Odor Mean Chey'                 => array(
					'family'   => 'Odor Mean Chey',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Offside'                        => array(
					'family'   => 'Offside',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Old Standard TT'                => array(
					'family'   => 'Old Standard TT',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Oldenburg'                      => array(
					'family'   => 'Oldenburg',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Oleo Script'                    => array(
					'family'   => 'Oleo Script',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Oleo Script Swash Caps'         => array(
					'family'   => 'Oleo Script Swash Caps',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Open Sans'                      => array(
					'family'   => 'Open Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '600',
						5 => '600italic',
						6 => '700',
						7 => '700italic',
						8 => '800',
						9 => '800italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Open Sans Condensed'            => array(
					'family'   => 'Open Sans Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Oranienbaum'                    => array(
					'family'   => 'Oranienbaum',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Orbitron'                       => array(
					'family'   => 'Orbitron',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '700',
						3 => '900',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Oregano'                        => array(
					'family'   => 'Oregano',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Orienta'                        => array(
					'family'   => 'Orienta',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Original Surfer'                => array(
					'family'   => 'Original Surfer',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Oswald'                         => array(
					'family'   => 'Oswald',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Over the Rainbow'               => array(
					'family'   => 'Over the Rainbow',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Overlock'                       => array(
					'family'   => 'Overlock',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
						4 => '900',
						5 => '900italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Overlock SC'                    => array(
					'family'   => 'Overlock SC',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Overpass'                       => array(
					'family'   => 'Overpass',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '600',
						9  => '600italic',
						10 => '700',
						11 => '700italic',
						12 => '800',
						13 => '800italic',
						14 => '900',
						15 => '900italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Overpass Mono'                  => array(
					'family'   => 'Overpass Mono',
					'category' => 'monospace',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '600',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Ovo'                            => array(
					'family'   => 'Ovo',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Oxygen'                         => array(
					'family'   => 'Oxygen',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Oxygen Mono'                    => array(
					'family'   => 'Oxygen Mono',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'PT Mono'                        => array(
					'family'   => 'PT Mono',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'PT Sans'                        => array(
					'family'   => 'PT Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'PT Sans Caption'                => array(
					'family'   => 'PT Sans Caption',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'PT Sans Narrow'                 => array(
					'family'   => 'PT Sans Narrow',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'PT Serif'                       => array(
					'family'   => 'PT Serif',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'PT Serif Caption'               => array(
					'family'   => 'PT Serif Caption',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Pacifico'                       => array(
					'family'   => 'Pacifico',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Padauk'                         => array(
					'family'   => 'Padauk',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'myanmar',
						1 => 'latin',
					),
				),
				'Palanquin'                      => array(
					'family'   => 'Palanquin',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Palanquin Dark'                 => array(
					'family'   => 'Palanquin Dark',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '600',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Pangolin'                       => array(
					'family'   => 'Pangolin',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Paprika'                        => array(
					'family'   => 'Paprika',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Parisienne'                     => array(
					'family'   => 'Parisienne',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Passero One'                    => array(
					'family'   => 'Passero One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Passion One'                    => array(
					'family'   => 'Passion One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
						2 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Pathway Gothic One'             => array(
					'family'   => 'Pathway Gothic One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Patrick Hand'                   => array(
					'family'   => 'Patrick Hand',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Patrick Hand SC'                => array(
					'family'   => 'Patrick Hand SC',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Pattaya'                        => array(
					'family'   => 'Pattaya',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Patua One'                      => array(
					'family'   => 'Patua One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Pavanam'                        => array(
					'family'   => 'Pavanam',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'tamil',
						2 => 'latin',
					),
				),
				'Paytone One'                    => array(
					'family'   => 'Paytone One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Peddana'                        => array(
					'family'   => 'Peddana',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Peralta'                        => array(
					'family'   => 'Peralta',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Permanent Marker'               => array(
					'family'   => 'Permanent Marker',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Petit Formal Script'            => array(
					'family'   => 'Petit Formal Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Petrona'                        => array(
					'family'   => 'Petrona',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Philosopher'                    => array(
					'family'   => 'Philosopher',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Piedra'                         => array(
					'family'   => 'Piedra',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Pinyon Script'                  => array(
					'family'   => 'Pinyon Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Pirata One'                     => array(
					'family'   => 'Pirata One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Plaster'                        => array(
					'family'   => 'Plaster',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Play'                           => array(
					'family'   => 'Play',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'cyrillic-ext',
						4 => 'cyrillic',
						5 => 'latin',
					),
				),
				'Playball'                       => array(
					'family'   => 'Playball',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Playfair Display'               => array(
					'family'   => 'Playfair Display',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
						4 => '900',
						5 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Playfair Display SC'            => array(
					'family'   => 'Playfair Display SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
						4 => '900',
						5 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Podkova'                        => array(
					'family'   => 'Podkova',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '600',
						3 => '700',
						4 => '800',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Poiret One'                     => array(
					'family'   => 'Poiret One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Poller One'                     => array(
					'family'   => 'Poller One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Poly'                           => array(
					'family'   => 'Poly',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Pompiere'                       => array(
					'family'   => 'Pompiere',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Pontano Sans'                   => array(
					'family'   => 'Pontano Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Poor Story'                     => array(
					'family'   => 'Poor Story',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Poppins'                        => array(
					'family'   => 'Poppins',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Port Lligat Sans'               => array(
					'family'   => 'Port Lligat Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Port Lligat Slab'               => array(
					'family'   => 'Port Lligat Slab',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Pragati Narrow'                 => array(
					'family'   => 'Pragati Narrow',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Prata'                          => array(
					'family'   => 'Prata',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Preahvihear'                    => array(
					'family'   => 'Preahvihear',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Press Start 2P'                 => array(
					'family'   => 'Press Start 2P',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'greek',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Pridi'                          => array(
					'family'   => 'Pridi',
					'category' => 'serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Princess Sofia'                 => array(
					'family'   => 'Princess Sofia',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Prociono'                       => array(
					'family'   => 'Prociono',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Prompt'                         => array(
					'family'   => 'Prompt',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Prosto One'                     => array(
					'family'   => 'Prosto One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Proza Libre'                    => array(
					'family'   => 'Proza Libre',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '500',
						3 => '500italic',
						4 => '600',
						5 => '600italic',
						6 => '700',
						7 => '700italic',
						8 => '800',
						9 => '800italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Puritan'                        => array(
					'family'   => 'Puritan',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Purple Purse'                   => array(
					'family'   => 'Purple Purse',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Quando'                         => array(
					'family'   => 'Quando',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Quantico'                       => array(
					'family'   => 'Quantico',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Quattrocento'                   => array(
					'family'   => 'Quattrocento',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Quattrocento Sans'              => array(
					'family'   => 'Quattrocento Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Questrial'                      => array(
					'family'   => 'Questrial',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Quicksand'                      => array(
					'family'   => 'Quicksand',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Quintessential'                 => array(
					'family'   => 'Quintessential',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Qwigley'                        => array(
					'family'   => 'Qwigley',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Racing Sans One'                => array(
					'family'   => 'Racing Sans One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Radley'                         => array(
					'family'   => 'Radley',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Rajdhani'                       => array(
					'family'   => 'Rajdhani',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Rakkas'                         => array(
					'family'   => 'Rakkas',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Raleway'                        => array(
					'family'   => 'Raleway',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Raleway Dots'                   => array(
					'family'   => 'Raleway Dots',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Ramabhadra'                     => array(
					'family'   => 'Ramabhadra',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Ramaraja'                       => array(
					'family'   => 'Ramaraja',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Rambla'                         => array(
					'family'   => 'Rambla',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Rammetto One'                   => array(
					'family'   => 'Rammetto One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Ranchers'                       => array(
					'family'   => 'Ranchers',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Rancho'                         => array(
					'family'   => 'Rancho',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Ranga'                          => array(
					'family'   => 'Ranga',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Rasa'                           => array(
					'family'   => 'Rasa',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'gujarati',
						2 => 'latin',
					),
				),
				'Rationale'                      => array(
					'family'   => 'Rationale',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Ravi Prakash'                   => array(
					'family'   => 'Ravi Prakash',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Redressed'                      => array(
					'family'   => 'Redressed',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Reem Kufi'                      => array(
					'family'   => 'Reem Kufi',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin',
					),
				),
				'Reenie Beanie'                  => array(
					'family'   => 'Reenie Beanie',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Revalia'                        => array(
					'family'   => 'Revalia',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Rhodium Libre'                  => array(
					'family'   => 'Rhodium Libre',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Ribeye'                         => array(
					'family'   => 'Ribeye',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Ribeye Marrow'                  => array(
					'family'   => 'Ribeye Marrow',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Righteous'                      => array(
					'family'   => 'Righteous',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Risque'                         => array(
					'family'   => 'Risque',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Roboto'                         => array(
					'family'   => 'Roboto',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '700',
						9  => '700italic',
						10 => '900',
						11 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Roboto Condensed'               => array(
					'family'   => 'Roboto Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '700',
						5 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Roboto Mono'                    => array(
					'family'   => 'Roboto Mono',
					'category' => 'monospace',
					'variants' => array(
						0 => '100',
						1 => '100italic',
						2 => '300',
						3 => '300italic',
						4 => 'regular',
						5 => 'italic',
						6 => '500',
						7 => '500italic',
						8 => '700',
						9 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Roboto Slab'                    => array(
					'family'   => 'Roboto Slab',
					'category' => 'serif',
					'variants' => array(
						0 => '100',
						1 => '300',
						2 => 'regular',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Rochester'                      => array(
					'family'   => 'Rochester',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Rock Salt'                      => array(
					'family'   => 'Rock Salt',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Rokkitt'                        => array(
					'family'   => 'Rokkitt',
					'category' => 'serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Romanesco'                      => array(
					'family'   => 'Romanesco',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Ropa Sans'                      => array(
					'family'   => 'Ropa Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Rosario'                        => array(
					'family'   => 'Rosario',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Rosarivo'                       => array(
					'family'   => 'Rosarivo',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Rouge Script'                   => array(
					'family'   => 'Rouge Script',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Rozha One'                      => array(
					'family'   => 'Rozha One',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Rubik'                          => array(
					'family'   => 'Rubik',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '500',
						5 => '500italic',
						6 => '700',
						7 => '700italic',
						8 => '900',
						9 => '900italic',
					),
					'subsets'  => array(
						0 => 'hebrew',
						1 => 'latin-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Rubik Mono One'                 => array(
					'family'   => 'Rubik Mono One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Ruda'                           => array(
					'family'   => 'Ruda',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
						2 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Rufina'                         => array(
					'family'   => 'Rufina',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Ruge Boogie'                    => array(
					'family'   => 'Ruge Boogie',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Ruluko'                         => array(
					'family'   => 'Ruluko',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Rum Raisin'                     => array(
					'family'   => 'Rum Raisin',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Ruslan Display'                 => array(
					'family'   => 'Ruslan Display',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Russo One'                      => array(
					'family'   => 'Russo One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Ruthie'                         => array(
					'family'   => 'Ruthie',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Rye'                            => array(
					'family'   => 'Rye',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Sacramento'                     => array(
					'family'   => 'Sacramento',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Sahitya'                        => array(
					'family'   => 'Sahitya',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'devanagari',
						1 => 'latin',
					),
				),
				'Sail'                           => array(
					'family'   => 'Sail',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Saira'                          => array(
					'family'   => 'Saira',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Saira Condensed'                => array(
					'family'   => 'Saira Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Saira Extra Condensed'          => array(
					'family'   => 'Saira Extra Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Saira Semi Condensed'           => array(
					'family'   => 'Saira Semi Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Salsa'                          => array(
					'family'   => 'Salsa',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Sanchez'                        => array(
					'family'   => 'Sanchez',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Sancreek'                       => array(
					'family'   => 'Sancreek',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Sansita'                        => array(
					'family'   => 'Sansita',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
						4 => '800',
						5 => '800italic',
						6 => '900',
						7 => '900italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Sarabun'                        => array(
					'family'   => 'Sarabun',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Sarala'                         => array(
					'family'   => 'Sarala',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Sarina'                         => array(
					'family'   => 'Sarina',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Sarpanch'                       => array(
					'family'   => 'Sarpanch',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '600',
						3 => '700',
						4 => '800',
						5 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Satisfy'                        => array(
					'family'   => 'Satisfy',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Sawarabi Gothic'                => array(
					'family'   => 'Sawarabi Gothic',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'vietnamese',
						2 => 'latin-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Sawarabi Mincho'                => array(
					'family'   => 'Sawarabi Mincho',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'japanese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Scada'                          => array(
					'family'   => 'Scada',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Scheherazade'                   => array(
					'family'   => 'Scheherazade',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin',
					),
				),
				'Schoolbell'                     => array(
					'family'   => 'Schoolbell',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Scope One'                      => array(
					'family'   => 'Scope One',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Seaweed Script'                 => array(
					'family'   => 'Seaweed Script',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Secular One'                    => array(
					'family'   => 'Secular One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'hebrew',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Sedgwick Ave'                   => array(
					'family'   => 'Sedgwick Ave',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Sedgwick Ave Display'           => array(
					'family'   => 'Sedgwick Ave Display',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Sevillana'                      => array(
					'family'   => 'Sevillana',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Seymour One'                    => array(
					'family'   => 'Seymour One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Shadows Into Light'             => array(
					'family'   => 'Shadows Into Light',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Shadows Into Light Two'         => array(
					'family'   => 'Shadows Into Light Two',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Shanti'                         => array(
					'family'   => 'Shanti',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Share'                          => array(
					'family'   => 'Share',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Share Tech'                     => array(
					'family'   => 'Share Tech',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Share Tech Mono'                => array(
					'family'   => 'Share Tech Mono',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Shojumaru'                      => array(
					'family'   => 'Shojumaru',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Short Stack'                    => array(
					'family'   => 'Short Stack',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Shrikhand'                      => array(
					'family'   => 'Shrikhand',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'gujarati',
						2 => 'latin',
					),
				),
				'Siemreap'                       => array(
					'family'   => 'Siemreap',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Sigmar One'                     => array(
					'family'   => 'Sigmar One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Signika'                        => array(
					'family'   => 'Signika',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '600',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Signika Negative'               => array(
					'family'   => 'Signika Negative',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '600',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Simonetta'                      => array(
					'family'   => 'Simonetta',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '900',
						3 => '900italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Sintony'                        => array(
					'family'   => 'Sintony',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Sirin Stencil'                  => array(
					'family'   => 'Sirin Stencil',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Six Caps'                       => array(
					'family'   => 'Six Caps',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Skranji'                        => array(
					'family'   => 'Skranji',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Slabo 13px'                     => array(
					'family'   => 'Slabo 13px',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Slabo 27px'                     => array(
					'family'   => 'Slabo 27px',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Slackey'                        => array(
					'family'   => 'Slackey',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Smokum'                         => array(
					'family'   => 'Smokum',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Smythe'                         => array(
					'family'   => 'Smythe',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Sniglet'                        => array(
					'family'   => 'Sniglet',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Snippet'                        => array(
					'family'   => 'Snippet',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Snowburst One'                  => array(
					'family'   => 'Snowburst One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Sofadi One'                     => array(
					'family'   => 'Sofadi One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Sofia'                          => array(
					'family'   => 'Sofia',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Song Myung'                     => array(
					'family'   => 'Song Myung',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Sonsie One'                     => array(
					'family'   => 'Sonsie One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Sorts Mill Goudy'               => array(
					'family'   => 'Sorts Mill Goudy',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Source Code Pro'                => array(
					'family'   => 'Source Code Pro',
					'category' => 'monospace',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '600',
						5 => '700',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Source Sans Pro'                => array(
					'family'   => 'Source Sans Pro',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '600',
						7  => '600italic',
						8  => '700',
						9  => '700italic',
						10 => '900',
						11 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'greek-ext',
						4 => 'cyrillic-ext',
						5 => 'cyrillic',
						6 => 'latin',
					),
				),
				'Source Serif Pro'               => array(
					'family'   => 'Source Serif Pro',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '600',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Space Mono'                     => array(
					'family'   => 'Space Mono',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Special Elite'                  => array(
					'family'   => 'Special Elite',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Spectral'                       => array(
					'family'   => 'Spectral',
					'category' => 'serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '600',
						9  => '600italic',
						10 => '700',
						11 => '700italic',
						12 => '800',
						13 => '800italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Spectral SC'                    => array(
					'family'   => 'Spectral SC',
					'category' => 'serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '500',
						7  => '500italic',
						8  => '600',
						9  => '600italic',
						10 => '700',
						11 => '700italic',
						12 => '800',
						13 => '800italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Spicy Rice'                     => array(
					'family'   => 'Spicy Rice',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Spinnaker'                      => array(
					'family'   => 'Spinnaker',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Spirax'                         => array(
					'family'   => 'Spirax',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Squada One'                     => array(
					'family'   => 'Squada One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Sree Krushnadevaraya'           => array(
					'family'   => 'Sree Krushnadevaraya',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Sriracha'                       => array(
					'family'   => 'Sriracha',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Srisakdi'                       => array(
					'family'   => 'Srisakdi',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Staatliches'                    => array(
					'family'   => 'Staatliches',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Stalemate'                      => array(
					'family'   => 'Stalemate',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Stalinist One'                  => array(
					'family'   => 'Stalinist One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Stardos Stencil'                => array(
					'family'   => 'Stardos Stencil',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Stint Ultra Condensed'          => array(
					'family'   => 'Stint Ultra Condensed',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Stint Ultra Expanded'           => array(
					'family'   => 'Stint Ultra Expanded',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Stoke'                          => array(
					'family'   => 'Stoke',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Strait'                         => array(
					'family'   => 'Strait',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Stylish'                        => array(
					'family'   => 'Stylish',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Sue Ellen Francisco'            => array(
					'family'   => 'Sue Ellen Francisco',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Suez One'                       => array(
					'family'   => 'Suez One',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'hebrew',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Sumana'                         => array(
					'family'   => 'Sumana',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Sunflower'                      => array(
					'family'   => 'Sunflower',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => '500',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Sunshiney'                      => array(
					'family'   => 'Sunshiney',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Supermercado One'               => array(
					'family'   => 'Supermercado One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Sura'                           => array(
					'family'   => 'Sura',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Suranna'                        => array(
					'family'   => 'Suranna',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Suravaram'                      => array(
					'family'   => 'Suravaram',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Suwannaphum'                    => array(
					'family'   => 'Suwannaphum',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Swanky and Moo Moo'             => array(
					'family'   => 'Swanky and Moo Moo',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Syncopate'                      => array(
					'family'   => 'Syncopate',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Tajawal'                        => array(
					'family'   => 'Tajawal',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '700',
						5 => '800',
						6 => '900',
					),
					'subsets'  => array(
						0 => 'arabic',
						1 => 'latin',
					),
				),
				'Tangerine'                      => array(
					'family'   => 'Tangerine',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Taprom'                         => array(
					'family'   => 'Taprom',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'khmer',
					),
				),
				'Tauri'                          => array(
					'family'   => 'Tauri',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Taviraj'                        => array(
					'family'   => 'Taviraj',
					'category' => 'serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Teko'                           => array(
					'family'   => 'Teko',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Telex'                          => array(
					'family'   => 'Telex',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Tenali Ramakrishna'             => array(
					'family'   => 'Tenali Ramakrishna',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Tenor Sans'                     => array(
					'family'   => 'Tenor Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Text Me One'                    => array(
					'family'   => 'Text Me One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Thasadith'                      => array(
					'family'   => 'Thasadith',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'The Girl Next Door'             => array(
					'family'   => 'The Girl Next Door',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Tienne'                         => array(
					'family'   => 'Tienne',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '700',
						2 => '900',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Tillana'                        => array(
					'family'   => 'Tillana',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '600',
						3 => '700',
						4 => '800',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Timmana'                        => array(
					'family'   => 'Timmana',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'telugu',
						1 => 'latin',
					),
				),
				'Tinos'                          => array(
					'family'   => 'Tinos',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'hebrew',
						3 => 'latin-ext',
						4 => 'greek-ext',
						5 => 'cyrillic-ext',
						6 => 'cyrillic',
						7 => 'latin',
					),
				),
				'Titan One'                      => array(
					'family'   => 'Titan One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Titillium Web'                  => array(
					'family'   => 'Titillium Web',
					'category' => 'sans-serif',
					'variants' => array(
						0  => '200',
						1  => '200italic',
						2  => '300',
						3  => '300italic',
						4  => 'regular',
						5  => 'italic',
						6  => '600',
						7  => '600italic',
						8  => '700',
						9  => '700italic',
						10 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Trade Winds'                    => array(
					'family'   => 'Trade Winds',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Trirong'                        => array(
					'family'   => 'Trirong',
					'category' => 'serif',
					'variants' => array(
						0  => '100',
						1  => '100italic',
						2  => '200',
						3  => '200italic',
						4  => '300',
						5  => '300italic',
						6  => 'regular',
						7  => 'italic',
						8  => '500',
						9  => '500italic',
						10 => '600',
						11 => '600italic',
						12 => '700',
						13 => '700italic',
						14 => '800',
						15 => '800italic',
						16 => '900',
						17 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'thai',
						3 => 'latin',
					),
				),
				'Trocchi'                        => array(
					'family'   => 'Trocchi',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Trochut'                        => array(
					'family'   => 'Trochut',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Trykker'                        => array(
					'family'   => 'Trykker',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Tulpen One'                     => array(
					'family'   => 'Tulpen One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Ubuntu'                         => array(
					'family'   => 'Ubuntu',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '500',
						5 => '500italic',
						6 => '700',
						7 => '700italic',
					),
					'subsets'  => array(
						0 => 'greek',
						1 => 'latin-ext',
						2 => 'greek-ext',
						3 => 'cyrillic-ext',
						4 => 'cyrillic',
						5 => 'latin',
					),
				),
				'Ubuntu Condensed'               => array(
					'family'   => 'Ubuntu Condensed',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'greek',
						1 => 'latin-ext',
						2 => 'greek-ext',
						3 => 'cyrillic-ext',
						4 => 'cyrillic',
						5 => 'latin',
					),
				),
				'Ubuntu Mono'                    => array(
					'family'   => 'Ubuntu Mono',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'greek',
						1 => 'latin-ext',
						2 => 'greek-ext',
						3 => 'cyrillic-ext',
						4 => 'cyrillic',
						5 => 'latin',
					),
				),
				'Ultra'                          => array(
					'family'   => 'Ultra',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Uncial Antiqua'                 => array(
					'family'   => 'Uncial Antiqua',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Underdog'                       => array(
					'family'   => 'Underdog',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'cyrillic',
						2 => 'latin',
					),
				),
				'Unica One'                      => array(
					'family'   => 'Unica One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'UnifrakturCook'                 => array(
					'family'   => 'UnifrakturCook',
					'category' => 'display',
					'variants' => array(
						0 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'UnifrakturMaguntia'             => array(
					'family'   => 'UnifrakturMaguntia',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Unkempt'                        => array(
					'family'   => 'Unkempt',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Unlock'                         => array(
					'family'   => 'Unlock',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Unna'                           => array(
					'family'   => 'Unna',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'VT323'                          => array(
					'family'   => 'VT323',
					'category' => 'monospace',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'latin',
					),
				),
				'Vampiro One'                    => array(
					'family'   => 'Vampiro One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Varela'                         => array(
					'family'   => 'Varela',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Varela Round'                   => array(
					'family'   => 'Varela Round',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'hebrew',
						2 => 'latin-ext',
						3 => 'latin',
					),
				),
				'Vast Shadow'                    => array(
					'family'   => 'Vast Shadow',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Vesper Libre'                   => array(
					'family'   => 'Vesper Libre',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '500',
						2 => '700',
						3 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Vibur'                          => array(
					'family'   => 'Vibur',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Vidaloka'                       => array(
					'family'   => 'Vidaloka',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Viga'                           => array(
					'family'   => 'Viga',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Voces'                          => array(
					'family'   => 'Voces',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Volkhov'                        => array(
					'family'   => 'Volkhov',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '700',
						3 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Vollkorn'                       => array(
					'family'   => 'Vollkorn',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => 'italic',
						2 => '600',
						3 => '600italic',
						4 => '700',
						5 => '700italic',
						6 => '900',
						7 => '900italic',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'greek',
						2 => 'latin-ext',
						3 => 'cyrillic-ext',
						4 => 'cyrillic',
						5 => 'latin',
					),
				),
				'Vollkorn SC'                    => array(
					'family'   => 'Vollkorn SC',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
						1 => '600',
						2 => '700',
						3 => '900',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Voltaire'                       => array(
					'family'   => 'Voltaire',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Waiting for the Sunrise'        => array(
					'family'   => 'Waiting for the Sunrise',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Wallpoet'                       => array(
					'family'   => 'Wallpoet',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Walter Turncoat'                => array(
					'family'   => 'Walter Turncoat',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Warnes'                         => array(
					'family'   => 'Warnes',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Wellfleet'                      => array(
					'family'   => 'Wellfleet',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Wendy One'                      => array(
					'family'   => 'Wendy One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Wire One'                       => array(
					'family'   => 'Wire One',
					'category' => 'sans-serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Work Sans'                      => array(
					'family'   => 'Work Sans',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '200',
						2 => '300',
						3 => 'regular',
						4 => '500',
						5 => '600',
						6 => '700',
						7 => '800',
						8 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Yanone Kaffeesatz'              => array(
					'family'   => 'Yanone Kaffeesatz',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '200',
						1 => '300',
						2 => 'regular',
						3 => '700',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic',
						3 => 'latin',
					),
				),
				'Yantramanav'                    => array(
					'family'   => 'Yantramanav',
					'category' => 'sans-serif',
					'variants' => array(
						0 => '100',
						1 => '300',
						2 => 'regular',
						3 => '500',
						4 => '700',
						5 => '900',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Yatra One'                      => array(
					'family'   => 'Yatra One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'devanagari',
						2 => 'latin',
					),
				),
				'Yellowtail'                     => array(
					'family'   => 'Yellowtail',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Yeon Sung'                      => array(
					'family'   => 'Yeon Sung',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'korean',
						1 => 'latin',
					),
				),
				'Yeseva One'                     => array(
					'family'   => 'Yeseva One',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'vietnamese',
						1 => 'latin-ext',
						2 => 'cyrillic-ext',
						3 => 'cyrillic',
						4 => 'latin',
					),
				),
				'Yesteryear'                     => array(
					'family'   => 'Yesteryear',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Yrsa'                           => array(
					'family'   => 'Yrsa',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => 'regular',
						2 => '500',
						3 => '600',
						4 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'ZCOOL KuaiLe'                   => array(
					'family'   => 'ZCOOL KuaiLe',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'chinese-simplified',
						1 => 'latin',
					),
				),
				'ZCOOL QingKe HuangYou'          => array(
					'family'   => 'ZCOOL QingKe HuangYou',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'chinese-simplified',
						1 => 'latin',
					),
				),
				'ZCOOL XiaoWei'                  => array(
					'family'   => 'ZCOOL XiaoWei',
					'category' => 'serif',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'chinese-simplified',
						1 => 'latin',
					),
				),
				'Zeyada'                         => array(
					'family'   => 'Zeyada',
					'category' => 'handwriting',
					'variants' => array(
						0 => 'regular',
					),
					'subsets'  => array(
						0 => 'latin',
					),
				),
				'Zilla Slab'                     => array(
					'family'   => 'Zilla Slab',
					'category' => 'serif',
					'variants' => array(
						0 => '300',
						1 => '300italic',
						2 => 'regular',
						3 => 'italic',
						4 => '500',
						5 => '500italic',
						6 => '600',
						7 => '600italic',
						8 => '700',
						9 => '700italic',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
				'Zilla Slab Highlight'           => array(
					'family'   => 'Zilla Slab Highlight',
					'category' => 'display',
					'variants' => array(
						0 => 'regular',
						1 => '700',
					),
					'subsets'  => array(
						0 => 'latin-ext',
						1 => 'latin',
					),
				),
			)
		);
	}
endif;

//Get fonts names
if (!function_exists('energy_get_google_fonts_array_keys')) :
	function energy_get_google_fonts_array_keys()
	{
		$energy_fonts = energy_get_google_fonts_array();
		$energy_r     = array(
			'' => esc_html__('Inherit', 'energy'),
		);
		foreach ($energy_fonts as $energy_name => $energy_font_options) {
			$energy_r[$energy_name] = $energy_name;
		}

		return $energy_r;
	}
endif;

//Get font variants
if (!function_exists('energy_get_google_font_properties')) :
	function energy_get_google_font_properties($energy_name = '', $energy_property = 'variants')
	{
		$energy_r = array();
		if (empty($energy_name)) {
			return $energy_r;
		}
		$energy_fonts = energy_get_google_fonts_array();
		if (!empty($energy_fonts[$energy_name][$energy_property])) {
			foreach ($energy_fonts[$energy_name][$energy_property] as $energy_prop) {
				$energy_r[$energy_prop] = $energy_prop;
			}
		}

		return $energy_r;
	}
endif;
