<?php

/**
 * Theme static files
 *
 * @package Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

/**
 * Enqueue scripts and styles.
 */
//front end styles and scripts
if (!function_exists('energy_enqueue_static')) :
	function energy_enqueue_static()
	{

		$min = energy_option('assets_min') ? 'min/' : '';

		//main theme css file
		wp_enqueue_style('energy-style', ENERGY_THEME_URI . '/assets/css/' . $min . 'style.css', array(), ENERGY_THEME_VERSION);

		$energy_colors_string = energy_get_root_colors_inline_styles_string();
		if (!empty($energy_colors_string)) :
			wp_add_inline_style(
				'energy-style',
				wp_kses(
					':root{' . $energy_colors_string . '}',
					false
				)
			);
		endif;

		$footer_menu_logo = energy_option('custom_logo');
		if (!empty($footer_menu_logo)) :
			wp_add_inline_style(
				'energy-style',
				wp_kses(
					'.widget_nav_menu.horizontal-menu.with-logo-img li.menu-item-home a::before{background-image:url(' . esc_url(wp_get_attachment_image_src($footer_menu_logo, 'full')[0]) . ') !important;}',
					false
				)
			);
		endif;

		$footer_menu_logo_inverse = energy_option('logo_image_inverse', '');
		if (!empty($footer_menu_logo_inverse)) :
			wp_add_inline_style(
				'energy-style',
				wp_kses(
					'.i .widget_nav_menu.horizontal-menu.with-logo-img li.menu-item-home a::before{background-image:url(' . esc_url($footer_menu_logo_inverse) . ') !important;}',
					false
				)
			);
		endif;

		wp_enqueue_style('font-awesome', ENERGY_THEME_URI . '/assets/css/' . $min . 'all.css', array(), ENERGY_THEME_VERSION);
		wp_enqueue_style('icomoon', ENERGY_THEME_URI . '/assets/css/' . $min . 'icomoon.css', array(), ENERGY_THEME_VERSION);
		wp_enqueue_style('specicons', ENERGY_THEME_URI . '/assets/css/' . $min . 'specicons.css', array(), ENERGY_THEME_VERSION);

		//Woo styles
		if (class_exists('WooCommerce')) {
			wp_enqueue_style('energy-shop-style', ENERGY_THEME_URI . '/assets/css/' . $min . 'shop.css', array(), ENERGY_THEME_VERSION);
		}

		//getting theme skin number
		$skin = energy_option('color_skin', '');
		if (!empty($skin)) {
			wp_enqueue_style('energy-skin', ENERGY_THEME_URI . '/assets/css/' . esc_attr($skin) . '.css', array(), ENERGY_THEME_VERSION);
		}

		//custom Google fonts css file and inline styles if option is enabled
		// based on:
		// https://gist.github.com/kailoon/e2dc2a04a8bd5034682c
		// http://themeshaper.com/2014/08/13/how-to-add-google-fonts-to-wordpress-themes/
		$energy_font_body     = json_decode(energy_option('font_body', '{"font":"","variant": [],"subset":[]}'));
		$energy_font_headings = json_decode(energy_option('font_headings', '{"font":"","variant": [],"subset":[]}'));
		//TODO subsets can exists even if no font selected
		if (!empty($energy_font_body->font) || !empty($energy_font_headings->font)) {
			/*
			Translators: If there are characters in your language that are not supported
			by chosen font(s), translate this to 'off'. Do not translate into your own language.
			*/

			if ('off' !== esc_html_x('on', 'Google font: on or off', 'energy')) {
				$energy_body_subsets  = array();
				$energy_font_body_font = '';
				if (!empty($energy_font_body->font)) {
					$energy_font_body_font = $energy_font_body->font;
					if (!empty($energy_font_body->variant)) {
						$energy_font_body->font .= ':' . implode(',', $energy_font_body->variant);
					}
					$energy_body_subsets  = $energy_font_body->subset;
				}

				$energy_headings_subsets  = array();
				$energy_font_headings_font = '';
				if (!empty($energy_font_headings->font)) {
					$energy_font_headings_font = $energy_font_headings->font;
					if (!empty($energy_font_headings->variant)) {
						$energy_font_headings->font .= ':' . implode(',', $energy_font_headings->variant);
					}
					$energy_headings_subsets  = $energy_font_headings->subset;
				}

				$energy_fonts    = array(
					'body'     => $energy_font_body->font,
					'headings' => $energy_font_headings->font,
				);
				$energy_subsets  = array(
					'body'     => implode(',', $energy_body_subsets),
					'headings' => implode(',', $energy_headings_subsets),
				);
				//'Montserrat|Bowlby One|Quattrocento Sans';
				$energy_fonts_string    = implode('|', array_filter($energy_fonts));
				$energy_subsets_string  = implode(',', array_filter($energy_subsets));

				$energy_query_args = array(
					'family' => urlencode($energy_fonts_string),
				);
				if (!empty($energy_subsets_string)) {
					$energy_query_args['subset'] = urlencode($energy_subsets_string);
				}
				$energy_query_args['display'] = 'swap';
				$energy_font_url = add_query_arg(
					$energy_query_args,
					'//fonts.googleapis.com/css'
				);

				//no need to provide anew version for Google fonts link
				wp_enqueue_style('energy-google-fonts-style', $energy_font_url, array(), '1.0.0');
				//printing header styles

				$energy_body_style = (!empty($energy_font_body_font)) ? 'body, button, input, select, textarea, .wp-block-calendar table caption{font-family:"' . $energy_font_body_font . '";}' : '';

				$energy_secondary_selectors = array(
					'.logo-text-primary',
					'h1',
					'h2',
					'h3',
					'h4',
					'h5',
					'h6',
				);

				$energy_headings_style = (!empty($energy_font_headings_font)) ? join(',', $energy_secondary_selectors) . '{font-family: "' . $energy_font_headings_font . '"}' : '';

				wp_add_inline_style(
					'energy-google-fonts-style',
					wp_kses(
						$energy_body_style . $energy_headings_style,
						false
					)
				);
			}
		}

		//admin-bar styles for front end
		if (is_admin_bar_showing()) {
			//Add Frontend admin styles
			wp_enqueue_style(
				'energy-admin-bar-style',
				ENERGY_THEME_URI . '/assets/css/admin-frontend.css',
				array(),
				ENERGY_THEME_VERSION
			);
		}

		//flexslider
		wp_enqueue_script('flexslider', ENERGY_THEME_URI . '/assets/js/vendor/jquery.flexslider-min.js', array('jquery'), ENERGY_THEME_VERSION, true);

		//owl-carousel
		wp_enqueue_script('owl-carousel', ENERGY_THEME_URI . '/assets/js/vendor/owl.carousel.min.js', array('jquery'), ENERGY_THEME_VERSION, true);

		//jquery-numerator
		wp_enqueue_script('jquery-numerator', ENERGY_THEME_URI . '/assets/js/vendor/jquery-numerator.min.js', array('jquery'), ENERGY_THEME_VERSION, true);

		//jquery-twentytwenty
		wp_enqueue_script('twentytwenty', ENERGY_THEME_URI . '/assets/js/vendor/jquery.twentytwenty.js', array('jquery'), ENERGY_THEME_VERSION, true);

		//jquery-event-move
		wp_enqueue_script('event-move', ENERGY_THEME_URI . '/assets/js/vendor/jquery.event.move.js', array('jquery'), ENERGY_THEME_VERSION, true);

		//always load masonry
		wp_enqueue_script('masonry', '', array('imagesloaded'), '', true);

		//photoswipe
		if (is_singular()) {
			wp_enqueue_style(
				'photoswipe',
				ENERGY_THEME_URI . '/assets/vendor/photoswipe/photoswipe.css',
				array(),
				ENERGY_THEME_VERSION
			);
			wp_enqueue_style(
				'photoswipe-skin',
				ENERGY_THEME_URI . '/assets/vendor/photoswipe/default-skin/default-skin.css',
				array('photoswipe'),
				ENERGY_THEME_VERSION
			);
			wp_enqueue_script('photoswipe', ENERGY_THEME_URI . '/assets/vendor/photoswipe/photoswipe.min.js', array(), ENERGY_THEME_VERSION, true);
			wp_enqueue_script('photoswipe-ui', ENERGY_THEME_URI . '/assets/vendor/photoswipe/photoswipe-ui-default.js', array('photoswipe'), ENERGY_THEME_VERSION, true);
		}

		//glightbox
		wp_enqueue_style(
			'glightbox',
			ENERGY_THEME_URI . '/assets/vendor/glightbox/glightbox.min.css',
			array(),
			ENERGY_THEME_VERSION
		);

		wp_enqueue_script('glightbox', ENERGY_THEME_URI . '/assets/vendor/glightbox/glightbox.min.js', array(), ENERGY_THEME_VERSION, true);

		$min_js = !ENERGY_DEV_MODE ? 'min/' : '';
		//main theme script
		wp_enqueue_script('energy-init-script', ENERGY_THEME_URI . '/assets/js/' . $min_js . 'init.js', array('jquery'), ENERGY_THEME_VERSION, true);

		//animation scripts and styles
		if (energy_option('animation_enabled', false)) :
			wp_enqueue_script('energy-animation-script', ENERGY_THEME_URI . '/assets/js/' . $min_js . 'animation.js', array(), ENERGY_THEME_VERSION, true);
			wp_enqueue_style('energy-animate', ENERGY_THEME_URI . '/assets/css/' . $min . 'animate.css', array(), ENERGY_THEME_VERSION);
		endif;

		//comments script
		if (is_singular() && comments_open() && get_option('thread_comments')) {
			wp_enqueue_script('comment-reply');
		}

		//move jQuery scripts to the footer if customizer option is active and if not user logged in
		if (energy_option('jquery_to_footer', false) && !is_user_logged_in()) :
			wp_scripts()->add_data('jquery', 'group', 1);
			wp_scripts()->add_data('jquery-core', 'group', 1);
			wp_scripts()->add_data('jquery-migrate', 'group', 1);
		endif;

		//customizer preview
		if (is_customize_preview()) {
			wp_enqueue_script('energy-customize-preview-script', ENERGY_THEME_URI . '/assets/js/' . $min_js . 'customize-preview.js', array('jquery', 'customize-selective-refresh'), ENERGY_THEME_VERSION, true);
		}
	}
endif;
add_action('wp_enqueue_scripts', 'energy_enqueue_static');

//enqueue masonry for grid layout
if (!function_exists('energy_enqueue_masonry')) :
	function energy_enqueue_masonry()
	{
		wp_enqueue_script('masonry', '', array('imagesloaded'), '', true);
	}
endif;
//enqueue masonry for grid layout action
if (!function_exists('energy_enqueue_masonry_action')) :
	function energy_enqueue_masonry_action()
	{
		add_action('wp_enqueue_scripts', 'energy_enqueue_masonry');
	}
endif;


//Gutenberg script
//https://developer.wordpress.org/block-editor/tutorials/javascript/loading-javascript/
if (!function_exists('energy_action_enqueue_block_editor_assets')) :
	function energy_action_enqueue_block_editor_assets($energy_page)
	{

		$min = !ENERGY_DEV_MODE ? 'min/' : '';

		$deps = array(
			'lodash',
			'wp-i18n',
			'wp-element',
			'wp-components',
			'wp-data',
			'wp-plugins',
			'wp-blocks',
			'wp-dom-ready',
		);
		//v 5.8 has block editor on widgets and throws error when 'edit post' scripts are loaded as a dependency
		$screen = function_exists('get_current_screen') ? get_current_screen() : false;
		if ($screen) {
			if ('widgets' !== $screen->id) {
				$deps[] = 'wp-edit-post';
				$deps[] = 'wp-editor';

				//animation scripts and styles
				if (energy_option('animation_enabled', false) && empty(energy_option('animation_disable_for_gutenberg', false))) :
					wp_enqueue_script(
						'gutenberg-animation',
						ENERGY_THEME_URI . '/assets/js/' . $min . 'gutenberg-animation.js',
						$deps,
						ENERGY_THEME_VERSION
					);
				endif;
			}
		}
		wp_enqueue_script(
			'gutenberg',
			ENERGY_THEME_URI . '/assets/js/' . $min . 'gutenberg.js',
			$deps,
			ENERGY_THEME_VERSION
		);
	}
endif;
add_action('enqueue_block_editor_assets', 'energy_action_enqueue_block_editor_assets');


//login page styles
if (!function_exists('energy_action_login_enqueue_static')) :
	function energy_action_login_enqueue_static($energy_page)
	{
		wp_enqueue_style(
			'energy-login-page-style',
			ENERGY_THEME_URI . '/assets/css/login-page.css',
			array(),
			ENERGY_THEME_VERSION
		);
		$energy_colors_string = energy_get_root_colors_inline_styles_string();
		if (!empty($energy_colors_string)) :
			wp_add_inline_style(
				'energy-login-page-style',
				wp_kses(
					':root{' . $energy_colors_string . '}',
					false
				)
			);
		endif;
	}
endif;
add_action('login_enqueue_scripts', 'energy_action_login_enqueue_static');

//customizer panel
if (!function_exists('energy_customizer_js')) :
	function energy_customizer_js()
	{
		wp_enqueue_style(
			'energy-customizer-style',
			ENERGY_THEME_URI . '/assets/css/customizer.css',
			array(),
			ENERGY_THEME_VERSION
		);
		$min = !ENERGY_DEV_MODE ? 'min/' : '';
		wp_register_script(
			'energy-customize-controls',
			ENERGY_THEME_URI . '/assets/js/' . $min . 'customize-controls.js',
			array(),
			ENERGY_THEME_VERSION,
			true
		);
		wp_localize_script('energy-customize-controls', 'mwtGoogleFonts', energy_get_google_fonts_array());

		//customizer redirect helpers
		$blog_url = get_post_type_archive_link('post');
		$post     = wp_get_recent_posts(
			array(
				'numberposts' => 1,
				'post_status' => 'publish',
			)
		);
		wp_reset_postdata();
		$post_url   = (!empty($post[0])) ? get_permalink($post[0]['ID']) : $blog_url;
		$search_url = home_url('/') . '?s=';
		$shop_url = esc_html(home_url('/'));
		$checkout_url = esc_html(home_url('/'));
		if (class_exists('WooCommerce')) {
			$shop_url = wc_get_page_permalink('shop');
			$checkout_url = wc_get_page_permalink('checkout');
		}
		wp_localize_script(
			'energy-customize-controls',
			'energyCustomizerObject',
			array(
				'homeUrl'     => esc_url_raw(home_url()),
				'blogUrl'     => esc_url_raw($blog_url),
				'postUrl'     => esc_url_raw($post_url),
				'searchUrl'   => esc_url_raw($search_url),
				'shopUrl'     => esc_url_raw($shop_url),
				'checkoutUrl' => esc_url_raw($checkout_url),
				'themeUrl'    => esc_url_raw(ENERGY_THEME_URI),
			)
		);

		wp_enqueue_script('energy-customize-controls');

		wp_register_script(
			'vue-runtime',
			ENERGY_THEME_URI . '/assets/js/vendor/vue.min.js',
			array(),
			ENERGY_THEME_VERSION,
			true
		);
		wp_enqueue_script('vue-runtime');
	}
endif;
add_action('customize_controls_enqueue_scripts', 'energy_customizer_js');

//admin styles
if (!function_exists('energy_action_load_custom_wp_admin_style')) :
	function energy_action_load_custom_wp_admin_style()
	{
		wp_register_style('energy-custom-wp-admin-css', ENERGY_THEME_URI . '/assets/css/admin-backend.css', false, ENERGY_THEME_VERSION);
		wp_enqueue_style('energy-custom-wp-admin-css');
		$energy_colors_string = energy_get_root_colors_inline_styles_string();
		if (!empty($energy_colors_string)) :
			wp_add_inline_style(
				'energy-custom-wp-admin-css',
				wp_kses(
					':root{' . $energy_colors_string . '}',
					false
				)
			);
		endif;
	} //energy_action_load_custom_wp_admin_style()
endif;
add_action('admin_enqueue_scripts', 'energy_action_load_custom_wp_admin_style');

//comment_date
add_filter('get_comment_date', 'energy_comment_date');
function energy_comment_date($date)
{
	$date = date("F d, Y");
	return $date;
}

//demo content on remote hosting
/**
 * @param FW_Ext_Backups_Demo[] $demos
 *
 * @return FW_Ext_Backups_Demo[]
 */
if (!function_exists('energy_filter_theme_fw_ext_backups_demos')) :

	function energy_filter_theme_fw_ext_backups_demos($demos)
	{
		$secret_demo_id = ENERGY_REMOTE_DEMO_ID; // as example: '12345678'

		$demo_version_suffix = '-v' . ENERGY_REMOTE_DEMO_VERSION; // '-v1.0.0' (Only for main demo)
		if (class_exists('FW_Ext_Backups_Demo')) :
			$demos_array = array(
				'energy-demo' . $demo_version_suffix => array(
					'title'        => esc_html__('Energy Demo', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-v2/'),
				),
				'energy-biogas-demo' => array(
					'title'        => esc_html__('Biogas Demo', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-biogas.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-biogas-v2/'),
				),
				'energy-geothermal-demo' => array(
					'title'        => esc_html__('Geothermal Demo', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-geothermal.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-geothermal-v2/'),
				),
				'energy-hydrostations-demo' => array(
					'title'        => esc_html__('Hydrostations Demo', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-hydrostations.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-hydrostations-v2/'),
				),
				'energy-pyrolysis-demo' => array(
					'title'        => esc_html__('Pyrolysis Demo', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-pyrolysis.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-pyrolysis-v2/'),
				),
				'energy-windmill-demo' => array(
					'title'        => esc_html__('Windmill Demo', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-windmill.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-windmill-v2/'),
				),
				'energy-shop-demo' => array(
					'title'        => esc_html__('Shop Demo', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-shop.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-shop-v2/'),
				),
			);

			// Demo ( Colorized )
			$demo_colorized_id = 'energy-demo-colorized-' . $secret_demo_id;
			if ($secret_demo_id) {
				$demos_array[$demo_colorized_id] = array(
					'title'        => esc_html__('Energy Demo (Colorized)', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-v2'),
				);
				$demos_array['energy-biogas-demo-colorized-' . $secret_demo_id] = array(
					'title'        => esc_html__('Biogas Demo (Colorized)', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-biogas.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-biogas-v2/'),
				);
				$demos_array['energy-geothermal-demo-colorized-' . $secret_demo_id] = array(
					'title'        => esc_html__('Geothermal Demo (Colorized)', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-geothermal.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-geothermal-v2/'),
				);
				$demos_array['energy-hydrostations-demo-colorized-' . $secret_demo_id] = array(
					'title'        => esc_html__('Hydrostations Demo (Colorized)', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-hydrostations.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-hydrostations-v2/'),
				);
				$demos_array['energy-pyrolysis-demo-colorized-' . $secret_demo_id] = array(
					'title'        => esc_html__('Pyrolysis Demo (Colorized)', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-pyrolysis.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-pyrolysis-v2/'),
				);
				$demos_array['energy-windmill-demo-colorized-' . $secret_demo_id] = array(
					'title'        => esc_html__('Windmill Demo (Colorized)', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-windmill.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-windmill-v2/'),
				);
				$demos_array['energy-shop-demo-colorized-' . $secret_demo_id] = array(
					'title'        => esc_html__('Shop Demo (Colorized)', 'energy'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/energy-v2/demo/screenshot-shop.png'),
					'preview_link' => esc_url('//webdesign-finder.com/energy-shop-v2/'),
				);
			}

			$download_url = esc_url('http://webdesign-finder.com/remote-demo-content/energy-v2/demo/');

			foreach ($demos_array as $id => $data) {
				$demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
					'url'     => $download_url,
					'file_id' => $id,
				));
				$demo->set_title($data['title']);
				$demo->set_screenshot($data['screenshot']);
				$demo->set_preview_link($data['preview_link']);

				$demos[$demo->get_id()] = $demo;

				unset($demo);
			}

			return $demos;

		endif; //class_exists
	} //energy_filter_theme_fw_ext_backups_demos()
endif;
add_filter('fw:ext:backups-demo:demos', 'energy_filter_theme_fw_ext_backups_demos');
