<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$energy_layouts           = energy_get_feed_layout_options( true );
$energy_gaps              = energy_get_feed_layout_gap_options( true );
$energy_sidebar_positions = energy_get_sidebar_position_options( true );

//options for categories
//returning array of fields
return array(
	'layout'           => array(
		'type'        => 'select',
		'label'       => esc_html__( 'Layout', 'energy' ),
		'description' => esc_html__( 'Category layout', 'energy' ),
		'default'     => '',
		'choices'     => $energy_layouts,
	),
	'gap'              => array(
		'type'        => 'select',
		'label'       => esc_html__( 'Items gap (for grid layouts)', 'energy' ),
		'description' => esc_html__( 'Gap between elements in pixels', 'energy' ),
		'default'     => '',
		'choices'     => $energy_gaps,
	),
	'sidebar_position' => array(
		'type'        => 'select',
		'label'       => esc_html__( 'Sidebar position', 'energy' ),
		'description' => esc_html__( 'Sidebar position for category', 'energy' ),
		'default'     => '',
		'choices'     => $energy_sidebar_positions,
	),
);
