<?php

/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 * @version 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$energy_css_classes = energy_get_layout_css_classes();

if (empty($energy_css_classes['aside'])) {
	if (is_customize_preview()) {
		echo '<aside id="aside" class="d-none"></aside>';
	}
	return;
}
$energy_sidebar_sticky       = energy_option('main_sidebar_sticky', false);
$energy_sidebar_sticky_class = !empty($energy_sidebar_sticky) ? ' sticky' : '';
$energy_font_size            = energy_option('sidebar_font_size', '');
$energy_sidebar_extra_class  = '';
if (is_page_template('page-templates/home.php') || is_front_page()) {
	if (is_active_sidebar('sidebar-home-after-columns')) {
		$energy_sidebar_extra_class .= 'with-after-columns-sidebar';
	}
}
?>
<aside id="aside" itemtype="https://schema.org/WPSideBar" itemscope="itemscope" class="<?php echo esc_attr($energy_css_classes['aside'] . ' ' . $energy_font_size . ' ' . $energy_sidebar_extra_class); ?>">
	<div class="widgets-wrap<?php echo esc_attr($energy_sidebar_sticky_class); ?>">

		<?php
		/**
		 * Fires at the top of aside column.
		 *
		 * @since Energy 0.0.1
		 */
		do_action('energy_action_top_of_aside_column');


		if (energy_is_shop()) {
			dynamic_sidebar('shop');
		} else {
			if (is_page_template('page-templates/home.php') || is_front_page()) {
				if (is_active_sidebar('sidebar-home-main')) {
					dynamic_sidebar('sidebar-home-main');
				} else {
					dynamic_sidebar('sidebar-1');
				}
			} else {
				dynamic_sidebar('sidebar-1');
			}
		}


		/**
		 * Fires at the bottom of aside column.
		 *
		 * @since Energy 0.0.1
		 */
		do_action('energy_action_bottom_of_aside_column');

		?>

	</div><!-- .widgets-wrap -->
</aside><!-- .column-aside -->