<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

?>
<div class="grid-item">
	<article id="post-<?php the_ID(); ?>" <?php post_class('vertical-item content-padding with-background'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
		<?php
		energy_sticky_post_label();
		energy_post_thumbnail('energy-square');
		?>
		<div class="item-content">
			<?php if (get_the_title()) : ?>
				<header class="entry-header">
					<?php
					the_title(sprintf('<h6 class="entry-title" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h6>');
					?>
				</header><!-- .entry-header -->
			<?php endif; //get_the_title 
			?>
			<div class="entry-meta post-meta">
				<?php
				if (
					!empty(energy_option('blog_show_date'))
					|| !empty(energy_option('blog_show_author'))
					|| !empty(energy_option('blog_show_categories'))
					|| !empty(energy_option('blog_show_comments_link'))
					|| !empty(energy_option('blog_show_views'))
					|| !empty(energy_option('blog_show_tags'))
				) :
				?>
					<div class="meta-left">
						<?php
						energy_entry_meta(true, true, true, true, true, true, true);
						?>
					</div>
				<?php
				endif;
				?>
			</div><!-- .entry-meta -->
		</div><!-- .item-content -->
	</article><!-- #post-<?php the_ID(); ?> -->
</div>