<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
    <div class="meta-cat mb-1">
        <?php energy_entry_meta( false, false, true, false, false,false ); ?>
    </div>
	<?php if ( get_the_title() ) : ?>
	<header class="entry-header">
		<?php
		energy_sticky_post_label();
		the_title( sprintf( '<h3 class="entry-title" itemprop="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
		?>
	</header><!-- .entry-header -->
	<?php endif; //get_the_title ?>

	<footer class="entry-footer entry-footer-top"><?php energy_entry_meta( true, true, false, false, true, false ); ?></footer>
	<!-- .entry-footer -->
	<?php
	energy_post_thumbnail();
	?>
	<div class="item-content">

		<div class="entry-content" itemprop="text">
			<?php
			$energy_show_full_text = energy_option( 'blog_show_full_text', false );

			if ( empty( $energy_show_full_text ) ) :

				the_excerpt();

			else :

				the_content(
					energy_read_more_inside_link_markup()
				);

			endif; // show_full_text

			wp_link_pages(
				energy_get_wp_link_pages_atts()
			);
			?>
		</div><!-- .entry-content -->

        <footer
                class="entry-footer  entry-footer-bottom meta-tags"><?php energy_entry_meta( false, false, false, true, false, false ); ?></footer>
        <!-- .entry-footer -->

	</div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->
