<?php
/**
 * The footer section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

//this footer displays only widgets so if has no widgets - it will be hidden
if ( ! is_active_sidebar( 'sidebar-footer' ) ) {
	if( is_customize_preview() ) {
		echo '<footer id="footer" class="d-none"></footer>';
	}
	return;
}

$energy_fluid = energy_option( 'footer_fluid' ) ? '-fluid' : '';

$energy_footer_background    = energy_option( 'footer_background', '' );
$energy_extra_padding_top    = energy_option( 'footer_extra_padding_top', '' );
$energy_extra_padding_bottom = energy_option( 'footer_extra_padding_bottom', '' );

$energy_border_top        = energy_option( 'footer_border_top', '' );
$energy_border_bottom     = energy_option( 'footer_border_bottom', '' );
$energy_font_size         = energy_option( 'footer_font_size', '' );
$energy_footer_layout_gap = energy_option( 'footer_layout_gap', '' );

$energy_background_image = energy_section_background_image_array( 'footer' );
?>
<footer id="footer"
		class="footer footer-3 <?php echo esc_attr( $energy_footer_background . ' ' . $energy_font_size . ' ' . $energy_background_image['class'] ); ?>"
	<?php echo ( ! empty( $energy_background_image['url'] ) ) ? 'style="background-image: url(' . esc_url( $energy_background_image['url'] ) . ');"' : ''; ?>
>
	<?php
	if ( 'full' === $energy_border_top ) {
		echo wp_kses_post( '<hr class="section-hr">' );
	}
	?>
	<div class="container<?php echo esc_attr( $energy_fluid . ' ' . $energy_extra_padding_top . ' ' . $energy_extra_padding_bottom ); ?>">
		<?php
		if ( 'container' === $energy_border_top ) {
			echo wp_kses_post( '<hr class="section-hr">' );
		}

		?>
		<div class="layout-cols-4 <?php echo esc_attr( 'layout-gap-' . $energy_footer_layout_gap ); ?>">
			<aside class="footer-widgets grid-wrapper one-half-second">
				<?php
				dynamic_sidebar( 'sidebar-footer' );
				?>
			</aside><!-- .footer-widgets> -->
		</div>
		<?php

		if ( 'container' === $energy_border_bottom ) {
			echo wp_kses_post( '<hr class="section-hr">' );
		}
		?>
	</div><!-- .container -->
	<?php
	if ( 'full' === $energy_border_bottom ) {
		echo wp_kses_post( '<hr class="section-hr">' );
	}
	?>
</footer><!-- #footer -->
