<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
//options
$energy_fluid             = energy_option('header_fluid') ? '-fluid' : '';
$energy_transparent       = energy_option('header_transparent') ? 'transparent' : '';
$energy_absolute          = energy_option('header_absolute') ? 'absolute' : '';
$energy_header_top_tall   = energy_option('header_top_tall') ? 'header-tall' : '';
$energy_sticky            = energy_option('header_sticky');
$energy_header_background = energy_option('header_background', '');
$energy_header_topline_bg = energy_option('header_topline_background', 'l');
$energy_font_size         = energy_option('header_font_size', '');

$energy_border_top    = energy_option('header_border_top', '');
$energy_border_bottom = energy_option('header_border_bottom', '');

$energy_toggler_side_in_header = energy_option('header_toggler_menu_side', true);
$energy_toggler_main_in_header = energy_option('header_toggler_menu_main', true);

$energy_header_align_main_menu = energy_option('header_align_main_menu', '');
$energy_header_has_menu_class  = has_nav_menu('primary') ? 'has-menu' : 'no-menu';

$energy_background_image = energy_section_background_image_array('header');

get_template_part('template-parts/header/toplogo/toplogo-2');

?>
<?php
if (!empty($energy_sticky)) :
?>
    <div id="header-affix-wrap" class="header-wrap <?php echo esc_attr($energy_header_background . ' ' . $energy_transparent . ' ' . $energy_absolute); ?>">
    <?php endif; //$energy_sticky 
    ?>
    <div id="overlay"></div>
    <header id="header" class="header header-3 <?php echo esc_attr($energy_header_background . ' ' . $energy_font_size . ' ' . $energy_header_align_main_menu . ' ' . $energy_sticky . ' ' . $energy_transparent . ' ' . $energy_absolute . ' ' . $energy_header_top_tall . ' ' . $energy_header_has_menu_class . ' ' . $energy_background_image['class']); ?>" <?php echo (!empty($energy_background_image['url'])) ? 'style="background-image: url(' . esc_url($energy_background_image['url']) . ');"' : ''; ?>>
        <?php
        if ('full' === $energy_border_top) {
            echo wp_kses_post('<hr class="section-hr">');
        }
        ?>
        <?php
        if ('container' === $energy_border_top) {
            echo wp_kses_post('<hr class="section-hr container">');
        }
        ?>
        <div class="container<?php echo esc_attr($energy_fluid); ?>">
            <?php if (!empty($energy_toggler_side_in_header) && (has_nav_menu('side') || is_active_sidebar('sidebar-side'))) : ?>
                <button id="nav_side_toggle" class="nav-btn" aria-controls="nav_side" aria-expanded="false" aria-label="<?php esc_attr_e('Side Menu Toggler', 'energy'); ?>">
                    <span></span>
                </button>
            <?php
            endif; //toggler_side_in_header
            ?>
            <?php
            if (has_nav_menu('primary')) :
            ?>
                <nav id="nav_top" class="top-nav" aria-label="<?php esc_attr_e('Top Menu', 'energy'); ?>">
                    <?php
                    if (has_nav_menu('primary')) :
                        $energy_menu_css_class = energy_get_menu_class_based_on_top_items_count('primary');
                        wp_nav_menu(
                            array(
                                'theme_location' => 'primary',
                                'menu_class'     => 'top-menu ' . $energy_menu_css_class,
                                'container'      => false,
                            )
                        );
                    endif; //has_nav_menu
                    if (empty($energy_toggler_main_in_header)) :
                    ?>
                        <button id="nav_toggle" class="nav-btn" aria-controls="nav_top" aria-expanded="false" aria-label="<?php esc_attr_e('Top Menu Toggler', 'energy'); ?>">
                            <span></span>
                        </button>
                    <?php
                    //echo closing button if main button is inside header section
                    else :
                    ?>
                        <button id="nav_close" class="nav-btn" aria-controls="nav_top" aria-expanded="true" aria-label="<?php esc_attr_e('Top Menu Close', 'energy'); ?>">
                            <span></span>
                        </button>
                    <?php endif; //toggler_main_in_header 
                    ?>
                </nav><!-- .top-nav -->
            <?php
            endif; //has_nav_menu 
            ?>
            <?php
            if (!empty($energy_toggler_main_in_header) && has_nav_menu('primary')) :
            ?>
                <button id="nav_toggle" class="nav-btn" aria-controls="nav_top" aria-expanded="false" aria-label="<?php esc_attr_e('Top Menu Toggler', 'energy'); ?>">
                    <span></span>
                </button>
            <?php endif; //toggler_main_in_header 
            ?>
            <!-- search box -->
            <?php get_template_part('template-parts/header/header-search'); ?>
            <div id="search_dropdown_alt" class="header-search">
                <form class="search-form" method="get" action="<?php echo esc_url(home_url('/')); ?>" role="search">
                    <?php esc_html_e('', 'energy') ?>
                    <input class="search-field" type="search" id="search-form__input" name="s" placeholder="<?php esc_html_e('Type and Hit Enter', 'energy') ?>" />
                    <button class="search-submit" type="submit"><?php energy_icon('magnify'); ?></button>
                    <label class="screen-reader-text" for="search-form__input"></label>
                </form>
            </div><!-- search_dropdown_alt -->
            <button id="search_modal_close_alt" class="search-btn" aria-controls="search_dropdown_alt" aria-expanded="true" aria-label="<?php esc_attr_e('Search Toggler', 'energy'); ?>">
                <?php energy_icon('close-circle'); ?>
            </button>
        </div><!-- .container -->
        <?php
        if ('container' === $energy_border_bottom) {
            echo wp_kses_post('<hr class="section-hr container">');
        }
        if ('full' === $energy_border_bottom) {
            echo wp_kses_post('<hr class="section-hr">');
        }
        ?>
    </header><!-- #header -->
    <?php if (!empty($energy_sticky)) : ?>
    </div>
    <!--#header-affix-wrap-->
<?php endif; //$energy_sticky 
?>