<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
//options
$energy_fluid             = energy_option('header_fluid') ? '-fluid' : '';
$energy_transparent       = energy_option('header_transparent') ? 'transparent' : '';
$energy_absolute          = energy_option('header_absolute') ? 'absolute' : '';
$energy_header_top_tall   = energy_option('header_top_tall') ? 'header-tall' : '';
$energy_sticky            = energy_option('header_sticky');
$energy_header_background = energy_option('header_background', '');
$energy_font_size         = energy_option('header_font_size', '');

$energy_border_top    = energy_option('header_border_top', '');
$energy_border_bottom = energy_option('header_border_bottom', '');

$energy_toggler_side_in_header = energy_option('header_toggler_menu_side', true);
$energy_toggler_main_in_header = energy_option('header_toggler_menu_main', true);

$energy_header_align_main_menu = energy_option('header_align_main_menu', '');

//meta
$energy_meta                 = energy_get_theme_meta();
$energy_header_meta          = energy_option('header_meta');

?>
<header id="header" class="page_header_side header_side_right header-7 <?php echo esc_attr($energy_header_background . ' ' . $energy_header_align_main_menu . ' ' . $energy_font_size . ' ' . $energy_sticky . ' ' . $energy_transparent . ' ' . $energy_absolute); ?>">
    <span class="toggle_menu_side"><span></span></span>
    <div class="scrollbar-macosx">
        <div class="side_header_inner">
            <div class="logo-wrap">
                <?php
                get_template_part('template-parts/header/logo/logo', energy_template_part('logo', '1'));
                ?>
            </div>
            <div class="header-side-menu">
                <nav class="mainmenu_side_wrapper">
                    <?php wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'menu_class'     => 'nav menu-side-click',
                        'container'      => 'ul'
                    )); ?>
                </nav>
            </div>
            <?php if ((!empty($energy_meta['phone']) || !empty($energy_meta['email'])) && !empty($energy_header_meta)) :
                $phone_from_meta = $energy_meta['phone'];
                $print_phone = preg_replace("/[^0-9]/", '', $phone_from_meta);
            ?>
                <span class="meta-wrap">
                    <strong><a class="phone darklink" href="tel:<?php echo esc_attr($print_phone); ?>"><?php echo wp_kses_post($energy_meta['phone']); ?></a></strong>
                    <a class="greylink" href="mailto:<?php echo esc_attr($energy_meta['email']); ?>"><?php echo wp_kses_post($energy_meta['email']); ?></a>
                </span>
            <?php
            endif; //meta 
            ?>
            <?php energy_social_links(); ?>
        </div><!-- eof .side_header_inner -->
    </div><!-- eof .scrollbar-macosx-->
</header><!-- eof .page_header_side-->