<?php

/**
 * The intro section text template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//text
$energy_intro_pre_heading = energy_option('intro_pre_heading', '');
$energy_intro_heading     = energy_option('intro_heading', '');
$energy_intro_description = energy_option('intro_description', '');
$energy_intro_shortcode   = energy_option('intro_shortcode', '');

//buttons
$energy_intro_button_text_first  = energy_option('intro_button_text_first', '');
$energy_intro_button_url_first   = energy_option('intro_button_url_first', '');
$energy_intro_button_text_second = energy_option('intro_button_text_second', '');
$energy_intro_button_url_second  = energy_option('intro_button_url_second', '');

//animation
//animate an__XXX
//intro_heading_animation
//intro_description_animation
//intro_button_first_animation
//intro_button_second_animation
//intro_shortcode_animation
$energy_intro_pre_heading_animation   = energy_option('intro_pre_heading_animation', '') ? 'animate an__' . energy_option('intro_pre_heading_animation') : '';
$energy_intro_heading_animation       = energy_option('intro_heading_animation', '') ? 'animate an__' . energy_option('intro_heading_animation') : '';
$energy_intro_description_animation   = energy_option('intro_description_animation', '') ? 'animate an__' . energy_option('intro_description_animation') : '';
$energy_intro_button_first_animation  = energy_option('intro_button_first_animation', '') ? 'animate an__' . energy_option('intro_button_first_animation') : '';
$energy_intro_button_second_animation = energy_option('intro_button_second_animation', '') ? 'animate an__' . energy_option('intro_button_second_animation') : '';
$energy_intro_shortcode_animation     = energy_option('intro_shortcode_animation', '') ? 'animate an__' . energy_option('intro_shortcode_animation') : '';


//not showing intro if no content specified
if (
	empty($energy_intro_pre_heading)
	&&
	empty($energy_intro_heading)
	&&
	empty($energy_intro_description)
	&&
	empty($energy_intro_shortcode)
	&&
	empty($energy_intro_button_text_first)
	&&
	empty($energy_intro_button_text_second)
) {
	return;
}

if (energy_option('intro_social_links')) {
	energy_social_links('intro-social-links');
}

if (!empty($energy_intro_pre_heading)) :
	$energy_intro_pre_heading_mt = energy_option('intro_pre_heading_mt', '');
	$energy_intro_pre_heading_mb = energy_option('intro_pre_heading_mb', '');
?>
	<div class="intro-pre-heading <?php echo esc_attr($energy_intro_pre_heading_animation . ' ' . $energy_intro_pre_heading_mt . ' ' . $energy_intro_pre_heading_mb); ?>">
		<?php echo wp_kses_post($energy_intro_pre_heading); ?>
	</div>
<?php
endif; //intro_heading

if (!empty($energy_intro_heading)) :
	$energy_intro_heading_mt = energy_option('intro_heading_mt', '');
	$energy_intro_heading_mb = energy_option('intro_heading_mb', '');
?>
	<h1 class="intro-heading <?php echo esc_attr($energy_intro_heading_animation . ' ' . $energy_intro_heading_mt . ' ' . $energy_intro_heading_mb); ?>">
		<?php echo wp_kses_post($energy_intro_heading); ?>
		<span class="intro-heading-duplicate d-none <?php echo esc_attr($energy_intro_heading_animation . ' ' . $energy_intro_heading_mt . ' ' . $energy_intro_heading_mb); ?>">
			<?php echo wp_kses_post($energy_intro_heading); ?>
		</span>
	</h1>

<?php
endif; //intro_heading

if (!empty($energy_intro_description)) :
	$energy_intro_description_mt = energy_option('intro_description_mt', '');
	$energy_intro_description_mb = energy_option('intro_description_mb', '');
?>
	<div class="intro-description grey <?php echo esc_attr($energy_intro_description_animation . ' ' . $energy_intro_description_mt . ' ' . $energy_intro_description_mb); ?>">
		<?php echo wp_kses_post($energy_intro_description); ?>
	</div>
<?php
endif; //intro_description

if (!empty($energy_intro_button_text_first) || !empty($energy_intro_button_text_second)) :
	$energy_intro_buttons_mt = energy_option('intro_buttons_mt', '');
	$energy_intro_buttons_mb = energy_option('intro_buttons_mb', '');
?>
	<div class="intro-buttons <?php echo esc_attr($energy_intro_buttons_mt . ' ' . $energy_intro_buttons_mb); ?>">
		<?php if (!empty($energy_intro_button_text_first)) : ?>
			<a class="theme_button wide_button color1 <?php echo esc_attr($energy_intro_button_first_animation); ?>" href="<?php echo esc_url($energy_intro_button_url_first); ?>"><?php echo esc_html($energy_intro_button_text_first); ?></a>
		<?php endif; //intro_button_text_first 
		?>
		<?php if (!empty($energy_intro_button_text_second)) : ?>
			<a class="theme_button wide_button color2 <?php echo esc_attr($energy_intro_button_second_animation); ?>" href="<?php echo esc_url($energy_intro_button_url_second); ?>"><?php echo esc_html($energy_intro_button_text_second); ?></a>
		<?php endif; //intro_button_text_second 
		?>
	</div>
<?php
endif; //intro_heading
if (!empty($energy_intro_shortcode)) :
	$energy_intro_shortcode_mt = energy_option('intro_shortcode_mt', '');
	$energy_intro_shortcode_mb = energy_option('intro_shortcode_mb', '');
?>
	<div class="intro-shortcode <?php echo esc_attr($energy_intro_shortcode_animation . ' ' . $energy_intro_shortcode_mt . ' ' . $energy_intro_shortcode_mb); ?>">
		<?php echo do_shortcode($energy_intro_shortcode); ?>
	</div>
<?php
endif; //intro_shortcode
