<?php

/**
 * The intro section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$energy_intro_layout      = energy_option('intro_layout', '');
$energy_intro_fullscreen  = energy_option('intro_fullscreen', '');
$energy_intro_heading     = energy_option('intro_heading', '');
$energy_intro_description = energy_option('intro_description', '');
$energy_intro_shortcode   = energy_option('intro_shortcode', '');

$energy_extra_padding_top    = energy_option('intro_extra_padding_top', '');
$energy_extra_padding_bottom = energy_option('intro_extra_padding_bottom', '');
$energy_intro_background     = energy_option('intro_background', '');
$energy_intro_alignment      = energy_option('intro_alignment', '');
$energy_font_size            = energy_option('intro_font_size', '');
$energy_background_image     = energy_section_background_image_array('intro');
$energy_image            = energy_option('intro_image', '');

$energy_intro_background_image_scale_class = energy_option('intro_background_image_scale', '') ? 'image-scale' : '';
$energy_intro_background_image_absolute_class = energy_option('intro_image_absolute', '') ? 'image-absolute' : '';

//buttons
$energy_intro_button_text_first  = energy_option('intro_button_text_first', '');
$energy_intro_button_url_first   = energy_option('intro_button_url_first', '');
$energy_intro_button_text_second = energy_option('intro_button_text_second', '');
$energy_intro_button_url_second  = energy_option('intro_button_url_second', '');

//animation
$energy_intro_image_animation = energy_option('intro_image_animation', '') ? 'animate an__' . energy_option('intro_image_animation') : '';

//not showing intro if no content specified
if (
	empty($energy_intro_heading)
	&&
	empty($energy_intro_description)
	&&
	empty($energy_intro_shortcode)
	&&
	empty($energy_intro_button_text_first)
	&&
	empty($energy_intro_button_text_second)
	&&
	empty($energy_background_image['url'])
) {
	return;
}
//if fullscreen - adding class to font size
if (!empty($energy_intro_fullscreen)) {
	$energy_font_size .= ' screen';
}

//default layout is background image
switch ($energy_intro_layout):
		//side image layout
	case 'image-left':
	case 'image-right':
?>
		<section id="intro" class="intro intro-section layout-gap-30 <?php echo esc_attr($energy_font_size . ' ' . $energy_intro_background . ' ' . $energy_intro_alignment . ' ' . $energy_intro_layout . ' ' . $energy_intro_background_image_scale_class . ' ' . $energy_intro_background_image_absolute_class . ' ' . $energy_background_image['class']); ?>" <?php echo (!empty($energy_background_image['url'])) ? 'style="background-image: url(' . esc_url($energy_background_image['url']) . ');"' : ''; ?>>
			<?php
			if (energy_option('intro_social_links')) {
				energy_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($energy_extra_padding_top . ' ' . $energy_extra_padding_bottom); ?>">
				<div class="d-grid grid-2-cols">
					<div class="column">
						<?php if (!empty($energy_image)) : ?>
							<div class="img-wrap">
								<img src="<?php echo esc_url($energy_image); ?>" alt="<?php echo esc_attr($energy_intro_heading); ?>" class="intro-image <?php echo esc_attr($energy_intro_image_animation); ?>">
							</div>
						<?php endif; ?>
					</div>
					<div class="column intro-section-text">
						<?php
						get_template_part('template-parts/header/intro-text');
						?>
					</div><!-- .column -->
				</div><!-- .d-grid -->
			</div><!-- .container -->
		</section><!-- #intro -->
	<?php
		break;

	case 'image-top':
	?>
		<section id="intro" class="intro intro-section <?php echo esc_attr($energy_font_size . ' ' . $energy_intro_background . ' ' . $energy_intro_alignment . ' ' . $energy_intro_layout . ' ' . $energy_background_image['class']); ?>" <?php echo (!empty($energy_background_image['url'])) ? 'style="background-image: url(' . esc_url($energy_background_image['url']) . ');"' : ''; ?>>
			<?php
			if (energy_option('intro_social_links')) {
				energy_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($energy_extra_padding_top . ' ' . $energy_extra_padding_bottom); ?>">
				<div class="column">
					<?php if (!empty($energy_image)) : ?>
						<img src="<?php echo esc_url($energy_image); ?>" alt="<?php echo esc_attr($energy_intro_heading); ?>" class="intro-image <?php echo esc_attr($energy_intro_image_animation); ?>">
					<?php endif; ?>
				</div>
				<div class="column intro-section-text">
					<?php
					get_template_part('template-parts/header/intro-text');
					?>
				</div><!-- .column -->
			</div><!-- .container -->
		</section><!-- #intro -->
	<?php
		break;
	case 'image-bottom':
	?>
		<section id="intro" class="intro intro-section <?php echo esc_attr($energy_font_size . ' ' . $energy_intro_background . ' ' . $energy_intro_alignment . ' ' . $energy_intro_layout . ' ' . $energy_background_image['class']); ?>" <?php echo (!empty($energy_background_image['url'])) ? 'style="background-image: url(' . esc_url($energy_background_image['url']) . ');"' : ''; ?>>
			<?php
			if (energy_option('intro_social_links')) {
				energy_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($energy_extra_padding_top . ' ' . $energy_extra_padding_bottom); ?>">
				<div class="column intro-section-text">
					<?php
					get_template_part('template-parts/header/intro-text');
					?>
				</div><!-- .column -->
				<div class="column">
					<?php if (!empty($energy_image)) : ?>
						<img src="<?php echo esc_url($energy_image); ?>" alt="<?php echo esc_attr($energy_intro_heading); ?>" class="intro-image <?php echo esc_attr($energy_intro_image_animation); ?>">
					<?php endif; ?>
				</div><!-- .column -->
			</div><!-- .container -->
		</section><!-- #intro -->
	<?php
		break;
		//background image
	default:
	?>
		<section id="intro" class="intro intro-section <?php echo esc_attr($energy_font_size . ' ' . $energy_intro_background . ' ' . $energy_intro_alignment . ' ' . $energy_background_image['class']); ?>" <?php echo (!empty($energy_background_image['url'])) ? 'style="background-image: url(' . esc_url($energy_background_image['url']) . ');"' : ''; ?>>
			<?php
			if (energy_option('intro_social_links')) {
				energy_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($energy_extra_padding_top . ' ' . $energy_extra_padding_bottom); ?>">
				<?php
				get_template_part('template-parts/header/intro-text');
				?>
			</div><!-- .container -->
		</section><!-- #intro -->
<?php
endswitch;//$energy_intro_layout
