<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//meta
$energy_meta                 = energy_get_theme_meta();

$energy_fluid                = energy_option('topline_fluid') ? '-fluid' : '';
$energy_topline_background   = energy_option('topline_background', '');
$energy_font_size            = energy_option('topline_font_size', '');

$energy_topline_meta_mail    = energy_option('topline_meta_mail');
$energy_topline_meta_phone   = energy_option('topline_meta_phone');
$energy_topline_meta_address = energy_option('topline_meta_address');
$energy_topline_meta_opening_hours = energy_option('topline_meta_opening_hours');

$energy_before_social_word = energy_option('topline_before_social_word', '');

?>
<div id="topline" class="topline topline-1 <?php echo esc_attr($energy_topline_background . ' ' . $energy_font_size); ?>">
    <div class="container<?php echo esc_attr($energy_fluid); ?>">
        <?php if (!empty($energy_meta)) : ?>
            <div class="site-meta">
                <?php
                if (!empty($energy_meta['opening_hours']) && $energy_topline_meta_opening_hours) :
                ?>
                    <span class="icon-inline">
                        <?php energy_icon('clock-outline'); ?>
                        <span>
                            <?php if (!empty($energy_meta['opening_hours_label'])) : ?>
                                <span class="hours-label"><?php echo wp_kses_post($energy_meta['opening_hours_label']); ?></span>
                            <?php endif; ?>
                            <span><?php echo wp_kses_post($energy_meta['opening_hours']); ?></span>
                        </span>
                    </span>
                <?php
                endif; //opening_hours
                if (!empty($energy_meta['email']) && $energy_topline_meta_mail) :
                ?>
                    <span class="icon-inline">
                        <?php energy_icon('email-outline'); ?>
                        <span>
                            <?php if (!empty($energy_meta['email_label'])) : ?>
                                <span class="email-label"><?php echo wp_kses_post($energy_meta['email_label']); ?></span>
                            <?php endif; ?>
                            <a href="mailto:<?php echo esc_attr($energy_meta['email']); ?>"><?php echo wp_kses_post($energy_meta['email']); ?></a>
                        </span>
                    </span>
                <?php
                endif; //email
                if (!empty($energy_meta['phone']) && $energy_topline_meta_phone) :
                    $phone_from_meta = $energy_meta['phone'];
                    $print_phone = preg_replace("/[^0-9]/", '', $phone_from_meta);
                ?>
                    <span class="icon-inline">
                        <?php energy_icon('phone-outline'); ?>
                        <span>
                            <?php if (!empty($energy_meta['phone_label'])) : ?>
                                <span class="phone-label"><?php echo wp_kses_post($energy_meta['phone_label']); ?></span>
                            <?php endif; ?>
                            <a class="phone" href="tel:<?php echo esc_attr($print_phone); ?>"><?php echo wp_kses_post($energy_meta['phone']); ?></a>
                        </span>
                    </span>
                <?php
                endif; //phone
                if (!empty($energy_meta['address']) && $energy_topline_meta_address) :
                ?>
                    <span class="icon-inline">
                        <?php energy_icon('map-marker-outline'); ?>
                        <span>
                            <?php if (!empty($energy_meta['address_label'])) : ?>
                                <span class="address-label"><?php echo wp_kses_post($energy_meta['address_label']); ?></span>
                            <?php endif; ?>
                            <span><?php echo wp_kses_post($energy_meta['address']); ?></span>
                        </span>
                    </span>
                <?php
                endif; //address
                ?>
            </div><!-- .site-meta -->
        <?php
        endif; //! empty meta
        ?>
        <div class="social-links-wrap">
            <span class="social-word meta-word">
                <?php echo esc_html($energy_before_social_word); ?>
            </span>
            <?php energy_social_links(); ?>
        </div>
    </div><!-- .container -->
</div><!-- #topline -->