<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//options
$energy_fluid             = energy_option('header_fluid') ? '-fluid' : '';
$energy_transparent       = energy_option('header_transparent') ? 'transparent' : '';
$energy_absolute          = energy_option('header_absolute') ? 'absolute' : '';
$energy_header_top_tall   = energy_option('header_top_tall') ? 'header-tall' : '';
$energy_sticky            = energy_option('header_sticky');
$energy_header_meta         = energy_option('header_meta') ? 'show-header-meta' : '';
$energy_header_background = energy_option('header_background', '');
$energy_header_toplogo_bg = energy_option('header_toplogo_background', 'l');
$energy_font_size         = energy_option('header_toplogo_font_size', '');

$energy_border_top    = energy_option('header_border_top', '');
$energy_border_bottom = energy_option('header_border_bottom', '');

//meta
$energy_meta                 = energy_get_theme_meta();
$header_meta                 = energy_option('header_meta');

$energy_toggler_side_in_header = energy_option('header_toggler_menu_side', true);
$energy_toggler_main_in_header = energy_option('header_toggler_menu_main', true);

$energy_header_align_main_menu = energy_option('header_align_main_menu', '');
$energy_header_has_menu_class  = has_nav_menu('primary') ? 'has-menu' : 'no-menu';

$header_toplogo = energy_option('header_toplogo');

if (!empty($header_toplogo)) :
?>
    <div id="toplogo" class="toplogo toplogo-1 <?php echo esc_attr($energy_font_size . ' ' . $energy_header_toplogo_bg . ' ' . $energy_header_top_tall); ?>">
        <div class="container<?php echo esc_attr($energy_fluid); ?> container-flex">
            <div class="logo-wrap darklinks">
                <?php
                get_template_part('template-parts/header/logo/logo', energy_template_part('logo', '1'));
                ?>
            </div>
            <?php if ((!empty($energy_meta['phone']) || !empty($energy_meta['email']) || !empty($energy_meta['address'])) && !empty($header_meta)) : ?>
                <div class="inline-teasers-wrap">
                <?php endif; ?>
                <?php
                if ((!empty($energy_meta['phone']) || !empty($energy_meta['email'])) && !empty($header_meta)) :
                    $phone_from_meta = $energy_meta['phone'];
                    $print_phone = preg_replace("/[^0-9]/", '', $phone_from_meta);
                ?>
                    <div class="teaser text-left">
                        <div class="teaser-left">
                            <div class="teaser_icon highlight border_icon"><?php energy_icon('paper-plane'); ?></div>
                        </div>
                        <div class="teaser-body">
                            <strong class="darklinks"><a class="phone" href="tel:<?php echo esc_attr($print_phone); ?>"><?php echo wp_kses_post($energy_meta['phone']); ?></a></strong>
                            <a class="" href="mailto:<?php echo esc_attr($energy_meta['email']); ?>"><?php echo wp_kses_post($energy_meta['email']); ?></a>
                        </div>
                    </div>
                <?php endif; // header_phone 
                ?>
                <?php
                if (!empty($energy_meta['address']) && !empty($header_meta)) :
                ?>
                    <div class="teaser text-left">
                        <div class="teaser-left">
                            <div class="teaser_icon highlight border_icon"><?php energy_icon('map-pin'); ?></div>
                        </div>
                        <div class="teaser-body">
                            <strong><?php echo wp_kses_post($energy_meta['address_label']); ?></strong>
                            <div><?php echo wp_kses_post($energy_meta['address']); ?></div>
                        </div>
                    </div>
                <?php
                endif; //email 
                ?>
                </div><!-- .inline-teasers-wrap -->
        </div>
    </div><!-- eof .col- -->
<?php endif; ?>