<?php

/**
 * The template for displaying all default single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('vertical-item with_shadow'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
	<?php
	energy_post_thumbnail('energy-default-post');
	?>
	<div class="item-content content-padding with-bottom-border">

		<div class="entry-meta post-meta">
			<?php
			if (
				!empty(energy_option('blog_single_show_categories'))
			) :
			?>
				<div class="highlightlinks">
					<?php
					energy_entry_meta(false, false, true, false, false, false, false);
					?>
				</div>
			<?php endif; ?>
		</div><!-- .entry-meta -->
		<header class="entry-header">
			<?php
			$energy_show_title = !energy_option('title_show_title', '') && get_the_title();
			if ($energy_show_title) :
			?>
				<?php the_title('<h1 class="entry-title" itemprop="headline"><span>', '</span></h1>'); ?>
			<?php
			else :
				echo '<h4 class="hidden" itemscope="itemscope" itemprop="headline" itemtype="https://schema.org/Text">' . esc_html(get_the_title()) . '</h4>';
			endif; //show_title
			?>
			<div class="after-title highlightlinks">
				<?php
				if (
					!empty(energy_option('blog_single_show_author'))
					|| !empty(energy_option('blog_single_show_date'))
					|| !empty(energy_option('blog_single_show_comments_link'))
				) :
				?>
					<?php
					energy_entry_meta(true, true, false, false, true, false, false);
					?>
				<?php
				endif;
				?>
			</div>
		</header><!-- .entry-header -->
		<?php
		if (
			!empty(energy_option('blog_single_show_likes'))
			||
			!empty(energy_option('blog_single_show_views'))
			||
			!empty(energy_option('blog_share_facebook', true))
			||
			!empty(energy_option('blog_share_twitter', true))
			||
			!empty(energy_option('blog_share_telegram', true))
			||
			!empty(energy_option('blog_share_pinterest', true))
			||
			!empty(energy_option('blog_share_linkedin', true))
		) {
		?>
			<div class="muted_background post-adds content-justify">
				<div class="content-justify">
					<?php
					if (function_exists('energy_share_this')) {
						energy_share_this();
					}
					if (!empty(energy_option('blog_single_show_likes'))) {
						energy_post_like_button(get_the_ID());
						energy_post_like_count(get_the_ID());
					}
					?>
				</div>
				<?php
				if (!empty(energy_option('blog_single_show_views'))) {
				?>
					<div>
						<span class="views-count gradient_bg">
							<?php
							energy_entry_meta(false, false, false, false, false, false, true);
							?>
						</span>
					</div>
				<?php } ?>
			</div> <!-- eof .post-adds -->
		<?php } ?>
		<div class="entry-content" itemprop="text">
			<?php
			the_content();

			wp_link_pages(
				energy_get_wp_link_pages_atts()
			);
			?>
		</div><!-- .entry-content -->
		<?php
		if (!empty(energy_option('blog_single_show_tags'))) :
		?>
			<footer class="entry-footer entry-footer-top">
				<div class="meta-left highlightlinks">
					<?php
					energy_entry_meta(false, false, false, true, false, false, false);
					?>
				</div>
			</footer><!-- .entry-footer-top -->
		<?php endif; ?>
		<?php
		// If comments are open or we have at least one comment, load up the comment template.
		if (comments_open() || get_comments_number()) {
			comments_template();
		}
		?>
	</div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->
<?php

energy_related_posts(get_the_ID());

//bio
get_template_part('template-parts/post/bio');

//nav
energy_post_nav();
?>