<?php

/**
 * View: List Event
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe/events/v2/list/event.php
 *
 * See more documentation about our views templating system.
 *
 * @link http://evnt.is/1aiy
 *
 * @version 5.0.0
 *
 * @var WP_Post $event The event post object with properties added by the `tribe_get_event` function.
 *
 * @see tribe_get_event() For the format of the event object.
 */


$event_classes = tribe_get_post_class(['with_shadow with-top-border'], $event->ID);
?>

<article <?php tribe_classes($event_classes) ?>>
	<?php $this->template('list/event/featured-image', ['event' => $event]); ?>

	<div class="tribe-events-calendar-list__item-content">

		<header class="tribe-events-calendar-list__event-header">
			<?php $this->template('list/event/title', ['event' => $event]); ?>
		</header>

		<?php $this->template('list/event/cost', ['event' => $event]); ?>
		<?php $this->template('list/event/description', ['event' => $event]); ?>

	</div>
</article>